/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.foraging;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;

public class ForagingAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public ForagingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.FORAGING);
    }

    public void lumberjack(Player player, Block block) {
        if (OptionL.isEnabled(Skills.FORAGING) && this.plugin.getAbilityManager().isEnabled(Ability.LUMBERJACK) && player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.LUMBERJACK) > 0 && this.r.nextDouble() < this.getValue(Ability.LUMBERJACK, playerData) / 100.0) {
                for (ItemStack item : block.getDrops(player.getInventory().getItemInMainHand())) {
                    PlayerLootDropEvent event = new PlayerLootDropEvent(player, item.clone(), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.LUMBERJACK);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    block.getWorld().dropItem(event.getLocation(), event.getItemStack());
                }
            }
        }
    }

    public void axeMaster(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (OptionL.isEnabled(Skills.FORAGING) && this.plugin.getAbilityManager().isEnabled(Ability.AXE_MASTER)) {
            if (!player.hasPermission("aureliumskills.foraging")) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.AXE_MASTER) > 0) {
                event.setDamage(event.getDamage() * (1.0 + this.getValue(Ability.AXE_MASTER, playerData) / 100.0));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void shredder(PlayerItemDamageEvent event) {
        EntityDamageByEntityEvent e;
        if (this.blockDisabled(Ability.SHREDDER)) {
            return;
        }
        if (!event.isCancelled() && ItemUtils.isArmor(event.getItem().getType()) && event.getPlayer().getLastDamageCause() instanceof EntityDamageByEntityEvent && (e = (EntityDamageByEntityEvent)event.getPlayer().getLastDamageCause()).getDamager() instanceof Player) {
            Material mat;
            Player player = (Player)e.getDamager();
            if (this.blockAbility(player)) {
                return;
            }
            if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) && ((mat = player.getInventory().getItemInMainHand().getType()).equals((Object)Material.DIAMOND_AXE) || mat.equals((Object)Material.IRON_AXE) || mat.equals((Object)XMaterial.GOLDEN_AXE.parseMaterial()) || mat.equals((Object)Material.STONE_AXE) || mat.equals((Object)XMaterial.WOODEN_AXE.parseMaterial()))) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                if (playerData.getAbilityLevel(Ability.SHREDDER) > 0 && this.r.nextDouble() < this.getValue(Ability.SHREDDER, playerData) / 100.0) {
                    event.setDamage(event.getDamage() * 3);
                }
            }
        }
    }

    public void applyValor(PlayerData playerData) {
        if (OptionL.isEnabled(Skills.FORAGING) && this.plugin.getAbilityManager().isEnabled(Ability.VALOR) && playerData.getAbilityLevel(Ability.VALOR) > 0) {
            playerData.addStatModifier(new StatModifier("foraging-valor", Stats.STRENGTH, (int)this.getValue(Ability.VALOR, playerData)));
        }
    }

    public void removeValor(PlayerData playerData) {
        playerData.removeStatModifier("foraging-valor");
    }
}

