/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.fishing;

import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum FishingSource implements Source
{
    COD,
    SALMON,
    TROPICAL_FISH,
    PUFFERFISH,
    TREASURE,
    JUNK,
    RARE,
    EPIC;


    @Override
    public Skill getSkill() {
        return Skills.FISHING;
    }

    @Override
    public String getPath() {
        return "fishing." + this.toString().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static FishingSource valueOf(ItemStack item) {
        Material mat = item.getType();
        if (XMaterial.isNewVersion()) {
            if (mat.equals((Object)XMaterial.COD.parseMaterial())) {
                return COD;
            }
            if (mat.equals((Object)XMaterial.SALMON.parseMaterial())) {
                return SALMON;
            }
            if (mat.equals((Object)XMaterial.TROPICAL_FISH.parseMaterial())) {
                return TROPICAL_FISH;
            }
            if (mat.equals((Object)XMaterial.PUFFERFISH.parseMaterial())) {
                return PUFFERFISH;
            }
        } else if (mat.equals((Object)XMaterial.COD.parseMaterial())) {
            switch (item.getDurability()) {
                case 0: {
                    return COD;
                }
                case 1: {
                    return SALMON;
                }
                case 2: {
                    return TROPICAL_FISH;
                }
                case 3: {
                    return PUFFERFISH;
                }
            }
        }
        if (mat.equals((Object)Material.BOW) || mat.equals((Object)Material.ENCHANTED_BOOK) || mat.equals((Object)Material.NAME_TAG) || mat.equals((Object)Material.SADDLE) || mat.equals((Object)XMaterial.NAUTILUS_SHELL.parseMaterial())) {
            return TREASURE;
        }
        if (mat.equals((Object)Material.BOWL) || mat.equals((Object)Material.LEATHER) || mat.equals((Object)Material.LEATHER_BOOTS) || mat.equals((Object)Material.ROTTEN_FLESH) || mat.equals((Object)Material.POTION) || mat.equals((Object)Material.BONE) || mat.equals((Object)Material.TRIPWIRE_HOOK) || mat.equals((Object)Material.STICK) || mat.equals((Object)Material.STRING) || mat.equals((Object)XMaterial.INK_SAC.parseMaterial()) || mat.equals((Object)XMaterial.LILY_PAD.parseMaterial()) || mat.equals((Object)XMaterial.BAMBOO.parseMaterial())) {
            return JUNK;
        }
        if (mat.equals((Object)Material.FISHING_ROD)) {
            if (item.getEnchantments().size() != 0) {
                return TREASURE;
            }
            return JUNK;
        }
        return null;
    }
}

