/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.fishing;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.loot.LootPool;
import com.archyx.aureliumskills.loot.LootTable;
import com.archyx.aureliumskills.loot.handler.LootHandler;
import com.archyx.aureliumskills.loot.type.CommandLoot;
import com.archyx.aureliumskills.loot.type.ItemLoot;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.fishing.FishingSource;
import com.archyx.aureliumskills.support.WorldGuardFlags;
import java.util.Random;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class FishingLootHandler
extends LootHandler
implements Listener {
    private final Random random = new Random();

    public FishingLootHandler(AureliumSkills plugin) {
        super(plugin, Skills.FISHING, Ability.FISHER);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFish(PlayerFishEvent event) {
        if (!OptionL.isEnabled(Skills.FISHING)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        if (this.plugin.getWorldManager().isInBlockedWorld(player.getLocation())) {
            return;
        }
        if (this.plugin.isWorldGuardEnabled()) {
            if (this.plugin.getWorldGuardSupport().isInBlockedRegion(player.getLocation())) {
                return;
            }
            if (this.plugin.getWorldGuardSupport().blockedByFlag(player.getLocation(), player, WorldGuardFlags.FlagKey.XP_GAIN)) {
                return;
            }
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        if (!event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) {
            return;
        }
        if (event.getExpToDrop() == 0) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        ItemStack originalItem = ((Item)event.getCaught()).getItemStack();
        FishingSource originalSource = FishingSource.valueOf(originalItem);
        LootTable table = this.plugin.getLootTableManager().getLootTable(Skills.FISHING);
        if (table == null) {
            return;
        }
        for (LootPool pool : table.getPools()) {
            Loot selectedLoot;
            FishingSource source;
            double chance = this.getCommonChance(pool, playerData);
            LootDropCause cause = LootDropCause.FISHING_OTHER_LOOT;
            if (pool.getName().equals("rare") && this.plugin.getAbilityManager().isEnabled(Ability.TREASURE_HUNTER)) {
                chance += this.getValue(Ability.TREASURE_HUNTER, playerData) / 100.0;
                source = FishingSource.RARE;
                cause = LootDropCause.TREASURE_HUNTER;
            } else if (pool.getName().equals("epic") && this.plugin.getAbilityManager().isEnabled(Ability.EPIC_CATCH)) {
                chance += this.getValue(Ability.EPIC_CATCH, playerData) / 100.0;
                source = FishingSource.EPIC;
                cause = LootDropCause.EPIC_CATCH;
            } else {
                source = originalSource;
            }
            if (!(this.random.nextDouble() < chance) || (selectedLoot = this.selectLoot(pool, originalSource)) == null) continue;
            if (selectedLoot instanceof ItemLoot) {
                ItemLoot itemLoot = (ItemLoot)selectedLoot;
                this.giveFishingItemLoot(player, itemLoot, event, source, cause);
                break;
            }
            if (!(selectedLoot instanceof CommandLoot)) break;
            CommandLoot commandLoot = (CommandLoot)selectedLoot;
            this.giveCommandLoot(player, commandLoot, source);
            break;
        }
    }
}

