/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.fishing;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FishingAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public FishingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.FISHING);
    }

    @EventHandler
    public void luckyCatch(PlayerFishEvent event) {
        Item item;
        ItemStack drop;
        PlayerData playerData;
        if (this.blockDisabled(Ability.LUCKY_CATCH)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        if (event.getCaught() instanceof Item && event.getExpToDrop() > 0 && (playerData = this.plugin.getPlayerManager().getPlayerData(player)) != null && this.r.nextDouble() < this.getValue(Ability.LUCKY_CATCH, playerData) / 100.0 && (drop = (item = (Item)event.getCaught()).getItemStack()).getMaxStackSize() > 1) {
            drop.setAmount(drop.getAmount() * 2);
            PlayerLootDropEvent dropEvent = new PlayerLootDropEvent(player, drop, item.getLocation(), LootDropCause.LUCKY_CATCH);
            Bukkit.getPluginManager().callEvent((Event)dropEvent);
            if (!event.isCancelled()) {
                item.setItemStack(dropEvent.getItemStack());
            }
        }
    }

    @EventHandler
    public void grappler(PlayerFishEvent event) {
        PlayerData playerData;
        if (this.blockDisabled(Ability.GRAPPLER)) {
            return;
        }
        if (event.getCaught() != null && !(event.getCaught() instanceof Item) && (playerData = this.plugin.getPlayerManager().getPlayerData(event.getPlayer())) != null) {
            Player player = event.getPlayer();
            if (this.blockAbility(player)) {
                return;
            }
            Vector vector = player.getLocation().toVector().subtract(event.getCaught().getLocation().toVector());
            Vector result = vector.multiply(0.004 + this.getValue(Ability.GRAPPLER, playerData) / 25000.0);
            if (this.isUnsafeVelocity(result)) {
                return;
            }
            event.getCaught().setVelocity(result);
        }
    }

    private boolean isUnsafeVelocity(Vector vector) {
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        return x > 4.0 || x < -4.0 || y > 4.0 || y < -4.0 || z > 4.0 || z < -4.0;
    }
}

