/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.fighting;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.fighting.FightingSource;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class FightingLeveler
extends SkillLeveler
implements Listener {
    public FightingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.FIGHTER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        block11: {
            if (OptionL.isEnabled(Skills.FIGHTING)) {
                EntityDamageByEntityEvent ee;
                if (OptionL.getBoolean(Option.FIGHTING_DAMAGE_BASED)) {
                    return;
                }
                LivingEntity e = event.getEntity();
                if (e.getKiller() != null && e.getLastDamageCause() instanceof EntityDamageByEntityEvent && (ee = (EntityDamageByEntityEvent)e.getLastDamageCause()).getDamager() instanceof Player) {
                    EntityType type = e.getType();
                    Player p = (Player)ee.getDamager();
                    if (this.blockXpGainLocation(e.getLocation(), p)) {
                        return;
                    }
                    if (this.blockXpGainPlayer(p)) {
                        return;
                    }
                    if (e.equals(p)) {
                        return;
                    }
                    double spawnerMultiplier = OptionL.getDouble(Option.FIGHTING_SPAWNER_MULTIPLIER);
                    try {
                        if (e.hasMetadata("aureliumskills_spawner_mob")) {
                            this.plugin.getLeveler().addXp(p, Skills.FIGHTING, spawnerMultiplier * this.getXp(p, FightingSource.valueOf(type.toString())));
                        } else {
                            this.plugin.getLeveler().addXp(p, Skills.FIGHTING, this.getXp(p, FightingSource.valueOf(type.toString())));
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        if (!type.toString().equals("PIG_ZOMBIE")) break block11;
                        if (e.hasMetadata("aureliumskills_spawner_mob")) {
                            this.plugin.getLeveler().addXp(p, Skills.FIGHTING, spawnerMultiplier * this.getXp(p, FightingSource.ZOMBIFIED_PIGLIN));
                        }
                        this.plugin.getLeveler().addXp(p, Skills.FIGHTING, this.getXp(p, FightingSource.ZOMBIFIED_PIGLIN));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        block12: {
            if (OptionL.isEnabled(Skills.FIGHTING)) {
                if (event.isCancelled()) {
                    return;
                }
                if (!OptionL.getBoolean(Option.FIGHTING_DAMAGE_BASED)) {
                    return;
                }
                if (event.getDamager() instanceof Player) {
                    Player player = (Player)event.getDamager();
                    if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
                        return;
                    }
                    if (event.getEntity() instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)event.getEntity();
                        if (this.blockXpGainLocation(entity.getLocation(), player)) {
                            return;
                        }
                        EntityType type = entity.getType();
                        if (this.blockXpGainPlayer(player)) {
                            return;
                        }
                        if (entity.equals(player)) {
                            return;
                        }
                        double health = entity.getHealth();
                        double damage = Math.min(health, event.getFinalDamage());
                        if (entity.hasMetadata("aureliumskills_spawner_mob")) {
                            double spawnerMultiplier = OptionL.getDouble(Option.FIGHTING_SPAWNER_MULTIPLIER);
                            damage *= spawnerMultiplier;
                        }
                        try {
                            this.plugin.getLeveler().addXp(player, Skills.FIGHTING, damage * this.getXp(player, FightingSource.valueOf(type.toString())));
                        }
                        catch (IllegalArgumentException e) {
                            if (!type.toString().equals("PIG_ZOMBIE")) break block12;
                            this.plugin.getLeveler().addXp(player, Skills.FIGHTING, damage * this.getXp(player, FightingSource.ZOMBIFIED_PIGLIN));
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER && (OptionL.isEnabled(Skills.FIGHTING) || OptionL.isEnabled(Skills.ARCHERY)) && (OptionL.getDouble(Option.ARCHERY_SPAWNER_MULTIPLIER) < 1.0 || OptionL.getDouble(Option.FIGHTING_SPAWNER_MULTIPLIER) < 1.0)) {
            LivingEntity entity = event.getEntity();
            entity.setMetadata("aureliumskills_spawner_mob", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
    }
}

