/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.fighting;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.AbilityData;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.AbilityMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Locale;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FightingAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public FightingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.FIGHTING);
    }

    public void swordMaster(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (OptionL.isEnabled(Skills.FIGHTING) && this.plugin.getAbilityManager().isEnabled(Ability.SWORD_MASTER)) {
            if (!player.hasPermission("aureliumskills.fighting")) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.SWORD_MASTER) > 0) {
                double modifier = this.getValue(Ability.SWORD_MASTER, playerData) / 100.0;
                event.setDamage(event.getDamage() * (1.0 + modifier));
            }
        }
    }

    public void firstStrike(EntityDamageByEntityEvent event, final PlayerData playerData, final Player player) {
        if (OptionL.isEnabled(Skills.FIGHTING) && this.plugin.getAbilityManager().isEnabled(Ability.FIRST_STRIKE) && !player.hasMetadata("AureliumSkills-FirstStrike") && playerData.getAbilityLevel(Ability.FIRST_STRIKE) > 0) {
            Locale locale = playerData.getLocale();
            double modifier = this.getValue(Ability.FIRST_STRIKE, playerData) / 100.0;
            event.setDamage(event.getDamage() * (1.0 + modifier));
            if (this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.FIRST_STRIKE, "enable_message")) {
                this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.FIRST_STRIKE_DEALT, locale));
            }
            player.setMetadata("AureliumSkills-FirstStrike", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            AbilityData abilityData = playerData.getAbilityData(Ability.FIRST_STRIKE);
            if (abilityData.containsKey("counter")) {
                abilityData.setData("counter", abilityData.getInt("counter") + 1);
            } else {
                abilityData.setData("counter", 0);
            }
            final int id = abilityData.getInt("counter");
            new BukkitRunnable(){

                public void run() {
                    if (playerData.getAbilityData(Ability.FIRST_STRIKE).containsKey("counter") && playerData.getAbilityData(Ability.FIRST_STRIKE).getInt("counter") == id) {
                        player.removeMetadata("AureliumSkills-FirstStrike", (Plugin)FightingAbilities.this.plugin);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 6000L);
        }
    }

    public void bleed(EntityDamageByEntityEvent event, PlayerData playerData, LivingEntity entity) {
        if (this.r.nextDouble() < this.getValue(Ability.BLEED, playerData) / 100.0 && event.getFinalDamage() < entity.getHealth()) {
            if (!entity.hasMetadata("AureliumSkills-BleedTicks")) {
                int baseTicks = this.plugin.getAbilityManager().getOption(Ability.BLEED, "base_ticks").asInt();
                entity.setMetadata("AureliumSkills-BleedTicks", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)baseTicks));
                if (this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.BLEED, "enable_enemy_message")) {
                    Locale locale = playerData.getLocale();
                    if (event.getDamager() instanceof Player) {
                        Player player = (Player)event.getDamager();
                        this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.BLEED_ENEMY_BLEEDING, locale));
                    }
                }
                if (entity instanceof Player && this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.BLEED, "enable_self_message")) {
                    Player player = (Player)entity;
                    Locale locale = this.plugin.getLang().getLocale(player);
                    this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.BLEED_SELF_BLEEDING, locale));
                }
                this.scheduleBleedTicks(entity, playerData);
            } else {
                int maxTicks;
                int addedTicks;
                int currentTicks = ((MetadataValue)entity.getMetadata("AureliumSkills-BleedTicks").get(0)).asInt();
                int resultingTicks = currentTicks + (addedTicks = this.plugin.getAbilityManager().getOption(Ability.BLEED, "added_ticks").asInt());
                if (resultingTicks <= (maxTicks = this.plugin.getAbilityManager().getOption(Ability.BLEED, "max_ticks").asInt())) {
                    entity.setMetadata("AureliumSkills-BleedTicks", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)resultingTicks));
                }
            }
        }
    }

    private void scheduleBleedTicks(final LivingEntity entity, final PlayerData playerData) {
        new BukkitRunnable(){

            public void run() {
                int bleedTicks;
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                if (entity.hasMetadata("AureliumSkills-BleedTicks") && (bleedTicks = ((MetadataValue)entity.getMetadata("AureliumSkills-BleedTicks").get(0)).asInt()) > 0) {
                    double damage = FightingAbilities.this.plugin.getAbilityManager().getValue2(Ability.BLEED, playerData.getAbilityLevel(Ability.BLEED));
                    double healthBefore = entity.getHealth();
                    entity.damage(damage);
                    double healthAfter = entity.getHealth();
                    if (healthAfter != healthBefore) {
                        FightingAbilities.this.displayBleedParticles(entity);
                    }
                    if (bleedTicks != 1) {
                        entity.setMetadata("AureliumSkills-BleedTicks", (MetadataValue)new FixedMetadataValue((Plugin)FightingAbilities.this.plugin, (Object)(bleedTicks - 1)));
                    } else {
                        entity.removeMetadata("AureliumSkills-BleedTicks", (Plugin)FightingAbilities.this.plugin);
                    }
                    return;
                }
                if (entity instanceof Player && FightingAbilities.this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.BLEED, "enable_stop_message")) {
                    Player player = (Player)entity;
                    Locale locale = FightingAbilities.this.plugin.getLang().getLocale(player);
                    FightingAbilities.this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.BLEED_STOP, locale));
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)this.plugin, 40L, (long)this.plugin.getAbilityManager().getOption(Ability.BLEED, "tick_period").asInt());
    }

    private void displayBleedParticles(LivingEntity entity) {
        if (!this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.BLEED, "show_particles")) {
            return;
        }
        Location location = entity.getLocation().add(0.0, entity.getHeight() * 0.6, 0.0);
        Object particleData = XMaterial.isNewVersion() ? Material.REDSTONE_BLOCK.createBlockData() : new MaterialData(Material.REDSTONE_BLOCK);
        entity.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 30, particleData);
    }

    @EventHandler
    public void onDeath(PlayerRespawnEvent event) {
        event.getPlayer().removeMetadata("AureliumSkills-BleedTicks", (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void fightingListener(EntityDamageByEntityEvent event) {
        if (OptionL.isEnabled(Skills.FIGHTING) && !event.isCancelled() && event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            if (this.blockAbility(player)) {
                return;
            }
            if (player.getInventory().getItemInMainHand().getType().name().toUpperCase().contains("SWORD")) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                if (this.isEnabled(Ability.BLEED) && event.getEntity() instanceof LivingEntity) {
                    this.bleed(event, playerData, (LivingEntity)event.getEntity());
                }
            }
        }
    }
}

