/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.farming;

import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.util.block.BlockUtil;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public enum FarmingSource implements Source
{
    WHEAT(new String[]{"CROPS"}, false, true),
    POTATO(new String[]{"POTATOES"}, false, true),
    CARROT(new String[]{"CARROTS"}, false, true),
    BEETROOT(new String[]{"BEETROOTS", "BEETROOT_BLOCK"}, false, true),
    NETHER_WART(new String[]{"NETHER_WARTS", "NETHER_STALK"}, false, true),
    PUMPKIN(true),
    MELON(new String[]{"MELON_BLOCK"}, true),
    SUGAR_CANE(new String[]{"SUGAR_CANE_BLOCK"}, true),
    BAMBOO(true),
    COCOA(null, false, true),
    CACTUS(true),
    BROWN_MUSHROOM(true),
    RED_MUSHROOM(true),
    KELP(new String[]{"KELP_PLANT"}, true),
    SEA_PICKLE(true),
    SWEET_BERRY_BUSH(null, false, false, 2, true),
    GLOW_BERRIES(new String[]{"CAVE_VINES", "CAVE_VINES_PLANT"}, false, false, 0, true);

    private String[] otherMaterials;
    private boolean checkBlockReplace;
    private boolean requiresFullyGrown;
    private int minGrowthStage;
    private boolean rightClickHarvestable;

    private FarmingSource() {
    }

    private FarmingSource(String ... otherMaterials) {
        this.otherMaterials = otherMaterials;
    }

    private FarmingSource(boolean checkBlockReplace) {
        this.checkBlockReplace = checkBlockReplace;
    }

    private FarmingSource(String[] otherMaterials, boolean checkBlockReplace) {
        this(otherMaterials);
        this.checkBlockReplace = checkBlockReplace;
    }

    private FarmingSource(String[] otherMaterials, boolean checkBlockReplace, boolean requiresFullyGrown) {
        this(otherMaterials, checkBlockReplace);
        this.requiresFullyGrown = requiresFullyGrown;
    }

    private FarmingSource(String[] otherMaterials, boolean checkBlockReplace, boolean requiresFullyGrown, int minGrowthStage) {
        this(otherMaterials, checkBlockReplace, requiresFullyGrown);
        this.minGrowthStage = minGrowthStage;
    }

    private FarmingSource(String[] otherMaterials, boolean checkBlockReplace, boolean requiresFullyGrown, int minGrowthStage, boolean rightClickHarvestable) {
        this(otherMaterials, checkBlockReplace, requiresFullyGrown, minGrowthStage);
        this.rightClickHarvestable = rightClickHarvestable;
    }

    public boolean shouldCheckBlockReplace() {
        return this.checkBlockReplace;
    }

    public boolean isRightClickHarvestable() {
        return this.rightClickHarvestable;
    }

    public boolean isMatch(Block block) {
        String materialName = block.getType().toString();
        boolean match = false;
        if (materialName.equalsIgnoreCase(this.toString())) {
            match = true;
        } else if (this.otherMaterials != null) {
            for (String sourceMaterial : this.otherMaterials) {
                if (!materialName.equalsIgnoreCase(sourceMaterial)) continue;
                match = true;
                break;
            }
        }
        if (this.requiresFullyGrown && match) {
            match = BlockUtil.isFullyGrown(block);
        }
        if (this.minGrowthStage > 0 && match) {
            match = BlockUtil.getGrowthStage(block) >= this.minGrowthStage;
        }
        return match;
    }

    @Override
    public Skill getSkill() {
        return Skills.FARMING;
    }

    @Nullable
    public static FarmingSource getSource(Block block) {
        for (FarmingSource source : FarmingSource.values()) {
            if (!source.isMatch(block)) continue;
            return source;
        }
        return null;
    }
}

