/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.farming;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.farming.FarmingAbilities;
import com.archyx.aureliumskills.skills.farming.FarmingSource;
import com.archyx.aureliumskills.source.SourceTag;
import com.archyx.aureliumskills.util.block.BlockUtil;
import com.archyx.aureliumskills.xseries.XBlock;
import com.archyx.aureliumskills.xseries.XMaterial;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.CaveVinesPlant;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FarmingLeveler
extends SkillLeveler
implements Listener {
    private final FarmingAbilities farmingAbilities;

    public FarmingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.FARMER);
        this.farmingAbilities = new FarmingAbilities(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!OptionL.isEnabled(Skills.FARMING)) {
            return;
        }
        if (OptionL.getBoolean(Option.FARMING_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockXpGainLocation(event.getBlock().getLocation(), player)) {
            return;
        }
        Block block = event.getBlock();
        if (this.blockXpGainPlayer(player)) {
            return;
        }
        for (FarmingSource source : FarmingSource.values()) {
            int numBroken;
            if (!source.isMatch(block)) continue;
            if (source.shouldCheckBlockReplace() && OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                return;
            }
            double multiplier = 1.0;
            if (source == FarmingSource.SUGAR_CANE) {
                numBroken = 1;
                BlockState above = block.getRelative(BlockFace.UP).getState();
                if (XBlock.isSugarCane(above.getType())) {
                    BlockState aboveAbove;
                    if (!this.plugin.getRegionManager().isPlacedBlock(above.getBlock())) {
                        ++numBroken;
                    }
                    if (XBlock.isSugarCane((aboveAbove = block.getRelative(BlockFace.UP).getRelative(BlockFace.UP).getState()).getType()) && !this.plugin.getRegionManager().isPlacedBlock(aboveAbove.getBlock())) {
                        ++numBroken;
                    }
                }
                multiplier = numBroken;
            }
            if (source == FarmingSource.BAMBOO || source == FarmingSource.CACTUS || source == FarmingSource.KELP) {
                numBroken = 1;
                if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                    if (!source.isMatch(block.getRelative(BlockFace.UP)) || this.plugin.getRegionManager().isPlacedBlock(block.getRelative(BlockFace.UP))) {
                        return;
                    }
                    numBroken = 0;
                }
                multiplier = numBroken += this.getSameBlocksAbove(block.getRelative(BlockFace.UP), source, 0);
            }
            if (source == FarmingSource.SEA_PICKLE && block.getBlockData() instanceof SeaPickle) {
                SeaPickle seaPickle = (SeaPickle)block.getBlockData();
                multiplier = seaPickle.getPickles();
            }
            if (source == FarmingSource.SWEET_BERRY_BUSH) {
                multiplier = BlockUtil.getGrowthStage(block) - 1;
            }
            if (source == FarmingSource.GLOW_BERRIES) {
                if (!(block.getBlockData() instanceof CaveVinesPlant)) {
                    return;
                }
                CaveVinesPlant caveVinesPlant = (CaveVinesPlant)block.getBlockData();
                if (!caveVinesPlant.isBerries()) {
                    return;
                }
            }
            this.giveXp(player, this.getXp(player, source) * multiplier, source, block);
            break;
        }
        this.checkCustomBlocks(player, block, Skills.FARMING);
    }

    private void giveXp(Player player, double amount, FarmingSource source, Block block) {
        this.plugin.getLeveler().addXp(player, Skills.FARMING, amount);
        if (this.hasTag(source, SourceTag.BOUNTIFUL_HARVEST_APPLICABLE)) {
            this.farmingAbilities.bountifulHarvest(player, block);
        }
        if (this.hasTag(source, SourceTag.TRIPLE_HARVEST_APPLICABLE)) {
            this.farmingAbilities.tripleHarvest(player, block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRightClick(PlayerInteractEvent event) {
        if (!OptionL.isEnabled(Skills.FARMING)) {
            return;
        }
        if (OptionL.getBoolean(Option.FARMING_CHECK_CANCELLED) && event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        final Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (this.blockXpGainLocation(block.getLocation(), player)) {
            return;
        }
        if (this.blockXpGainPlayer(player)) {
            return;
        }
        for (final FarmingSource source : FarmingSource.values()) {
            if (!source.isRightClickHarvestable() || !source.isMatch(block)) continue;
            if (player.isSneaking() && this.isHoldingItem(player)) {
                return;
            }
            if (source == FarmingSource.SWEET_BERRY_BUSH) {
                final double multiplier = BlockUtil.getGrowthStage(block) - 1;
                new BukkitRunnable(){

                    public void run() {
                        if (block.getType() == XMaterial.SWEET_BERRY_BUSH.parseMaterial() && BlockUtil.getGrowthStage(block) <= 1) {
                            FarmingLeveler.this.giveXp(player, FarmingLeveler.this.getXp(player, source) * multiplier, source, block);
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
            }
            if (source != FarmingSource.GLOW_BERRIES) break;
            if (!(block.getBlockData() instanceof CaveVinesPlant)) {
                return;
            }
            CaveVinesPlant caveVinesPlant = (CaveVinesPlant)block.getBlockData();
            if (!caveVinesPlant.isBerries()) break;
            this.giveXp(player, this.getXp(player, source), source, block);
            break;
        }
    }

    private boolean isHoldingItem(Player player) {
        return player.getInventory().getItemInMainHand().getType() != Material.AIR || player.getInventory().getItemInOffHand().getType() != Material.AIR;
    }

    private int getSameBlocksAbove(Block block, FarmingSource source, int num) {
        if (source.isMatch(block)) {
            if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                return num;
            }
            return this.getSameBlocksAbove(block.getRelative(BlockFace.UP), source, ++num);
        }
        return num;
    }
}

