/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.farming;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class FarmingAbilities
extends AbilityProvider
implements Listener {
    private static final Random r = new Random();

    public FarmingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.FARMING);
    }

    public void bountifulHarvest(Player player, Block block) {
        if (OptionL.isEnabled(Skills.FARMING) && this.plugin.getAbilityManager().isEnabled(Ability.BOUNTIFUL_HARVEST) && player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.BOUNTIFUL_HARVEST) > 0 && r.nextDouble() < this.getValue(Ability.BOUNTIFUL_HARVEST, playerData) / 100.0) {
                for (ItemStack item : block.getDrops()) {
                    this.checkMelonSilkTouch(player, block, item);
                    PlayerLootDropEvent event = new PlayerLootDropEvent(player, item.clone(), block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.BOUNTIFUL_HARVEST);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    block.getWorld().dropItem(event.getLocation(), event.getItemStack());
                }
            }
        }
    }

    public void tripleHarvest(Player player, Block block) {
        if (OptionL.isEnabled(Skills.FARMING) && this.plugin.getAbilityManager().isEnabled(Ability.TRIPLE_HARVEST) && player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.TRIPLE_HARVEST) > 0 && r.nextDouble() < this.getValue(Ability.TRIPLE_HARVEST, playerData) / 100.0) {
                for (ItemStack item : block.getDrops()) {
                    this.checkMelonSilkTouch(player, block, item);
                    ItemStack droppedItem = item.clone();
                    droppedItem.setAmount(2);
                    PlayerLootDropEvent event = new PlayerLootDropEvent(player, droppedItem, block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.TRIPLE_HARVEST);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    block.getWorld().dropItem(event.getLocation(), event.getItemStack());
                }
            }
        }
    }

    private void checkMelonSilkTouch(Player player, Block block, ItemStack item) {
        Material melon;
        if (block.getType() == XMaterial.MELON.parseMaterial() && player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0 && (melon = XMaterial.MELON.parseMaterial()) != null) {
            item.setType(melon);
            item.setAmount(1);
        }
    }

    @EventHandler
    public void geneticist(PlayerItemConsumeEvent event) {
        if (this.blockDisabled(Ability.GENETICIST)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        Material mat = event.getItem().getType();
        if (mat.equals((Object)Material.BREAD) || mat.equals((Object)Material.APPLE) || mat.equals((Object)Material.GOLDEN_APPLE) || mat.equals((Object)XMaterial.POTATO.parseMaterial()) || mat.equals((Object)Material.BAKED_POTATO) || mat.equals((Object)XMaterial.CARROT.parseMaterial()) || mat.equals((Object)Material.GOLDEN_CARROT) || mat.equals((Object)Material.MELON) || mat.equals((Object)Material.PUMPKIN_PIE) || mat.equals((Object)Material.BEETROOT) || mat.equals((Object)Material.BEETROOT_SOUP) || mat.equals((Object)XMaterial.MUSHROOM_STEW.parseMaterial()) || mat.equals((Object)Material.POISONOUS_POTATO)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            float amount = (float)this.getValue(Ability.GENETICIST, playerData) / 10.0f;
            player.setSaturation(player.getSaturation() + amount);
        }
    }

    public void scytheMaster(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (this.blockDisabled(Ability.SCYTHE_MASTER)) {
            return;
        }
        if (!player.hasPermission("aureliumskills.farming")) {
            return;
        }
        if (playerData.getAbilityLevel(Ability.SCYTHE_MASTER) > 0) {
            event.setDamage(event.getDamage() * (1.0 + this.getValue(Ability.SCYTHE_MASTER, playerData) / 100.0));
        }
    }
}

