/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.excavation;

import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.source.BlockSource;
import com.archyx.aureliumskills.source.Source;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public enum ExcavationSource implements Source,
BlockSource
{
    DIRT("DIRT", 0),
    GRASS_BLOCK("GRASS"),
    SAND("SAND", 0),
    GRAVEL,
    MYCELIUM("MYCEL"),
    CLAY,
    SOUL_SAND,
    COARSE_DIRT("DIRT", 1),
    PODZOL("DIRT", 2),
    SOUL_SOIL,
    RED_SAND("SAND", 1),
    ROOTED_DIRT;

    private final String legacyMaterial;
    private final byte legacyData;
    private final boolean allowBothIfLegacy;

    private ExcavationSource() {
        this(null, -1, false);
    }

    private ExcavationSource(String legacyMaterial) {
        this(legacyMaterial, -1, false);
    }

    private ExcavationSource(String legacyMaterial, int legacyData) {
        this(legacyMaterial, legacyData, false);
    }

    private ExcavationSource(String legacyMaterial, boolean allowBothIfLegacy) {
        this(legacyMaterial, -1, allowBothIfLegacy);
    }

    private ExcavationSource(String legacyMaterial, int legacyData, boolean allowBothIfLegacy) {
        this.legacyMaterial = legacyMaterial;
        this.legacyData = (byte)legacyData;
        this.allowBothIfLegacy = allowBothIfLegacy;
    }

    @Override
    @Nullable
    public String getLegacyMaterial() {
        return this.legacyMaterial;
    }

    @Override
    public byte getLegacyData() {
        return this.legacyData;
    }

    @Override
    public boolean allowBothIfLegacy() {
        return this.allowBothIfLegacy;
    }

    @Override
    public Skill getSkill() {
        return Skills.EXCAVATION;
    }

    @Nullable
    public static ExcavationSource getSource(Block block) {
        for (ExcavationSource source : ExcavationSource.values()) {
            if (!source.isMatch(block)) continue;
            return source;
        }
        return null;
    }
}

