/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.excavation;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.excavation.ExcavationAbilities;
import com.archyx.aureliumskills.skills.excavation.ExcavationSource;
import com.archyx.aureliumskills.source.SourceTag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class ExcavationLeveler
extends SkillLeveler
implements Listener {
    private final ExcavationAbilities excavationAbilities;

    public ExcavationLeveler(AureliumSkills plugin) {
        super(plugin, Ability.EXCAVATOR);
        this.excavationAbilities = new ExcavationAbilities(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!OptionL.isEnabled(Skills.EXCAVATION)) {
            return;
        }
        if (OptionL.getBoolean(Option.EXCAVATION_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockXpGainLocation(event.getBlock().getLocation(), player)) {
            return;
        }
        if (this.blockXpGainPlayer(player)) {
            return;
        }
        for (ExcavationSource source : ExcavationSource.values()) {
            if (!source.isMatch(block)) continue;
            this.plugin.getLeveler().addXp(player, Skills.EXCAVATION, this.getXp(player, source));
            if (!this.hasTag(source, SourceTag.BIGGER_SCOOP_APPLICABLE) || !event.isDropItems()) break;
            this.excavationAbilities.biggerScoop(source, block, player);
            break;
        }
        this.checkCustomBlocks(player, block, Skills.EXCAVATION);
    }
}

