/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.excavation;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.excavation.ExcavationSource;
import com.archyx.aureliumskills.util.version.VersionUtils;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class ExcavationAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public ExcavationAbilities(AureliumSkills plugin) {
        super(plugin, Skills.EXCAVATION);
    }

    public void spadeMaster(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (OptionL.isEnabled(Skills.EXCAVATION) && this.plugin.getAbilityManager().isEnabled(Ability.SPADE_MASTER)) {
            if (!player.hasPermission("aureliumskills.excavation")) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.SPADE_MASTER) > 0) {
                event.setDamage(event.getDamage() * (1.0 + this.getValue(Ability.SPADE_MASTER, playerData) / 100.0));
            }
        }
    }

    public void biggerScoop(ExcavationSource source, Block block, Player player) {
        if (!this.plugin.getAbilityManager().isEnabled(Ability.BIGGER_SCOOP)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (this.r.nextDouble() < this.getValue(Ability.BIGGER_SCOOP, playerData) / 100.0) {
            ItemStack tool = player.getInventory().getItemInMainHand();
            Material mat = block.getType();
            for (ItemStack item : block.getDrops(tool)) {
                if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0) {
                    Location loc = block.getLocation().add(0.5, 0.5, 0.5);
                    PlayerLootDropEvent event = source.getLegacyData() == -1 ? new PlayerLootDropEvent(player, new ItemStack(mat, 2), loc, LootDropCause.BIGGER_SCOOP) : (VersionUtils.isAtLeastVersion(13) ? new PlayerLootDropEvent(player, new ItemStack(mat, 2), loc, LootDropCause.BIGGER_SCOOP) : new PlayerLootDropEvent(player, new ItemStack(mat, 2, (short)source.getLegacyData()), loc, LootDropCause.BIGGER_SCOOP));
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    block.getWorld().dropItem(event.getLocation(), event.getItemStack());
                    continue;
                }
                ItemStack drop = item.clone();
                drop.setAmount(2);
                PlayerLootDropEvent event = new PlayerLootDropEvent(player, drop, block.getLocation().add(0.5, 0.5, 0.5), LootDropCause.BIGGER_SCOOP);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                block.getWorld().dropItem(event.getLocation(), event.getItemStack());
            }
        }
    }
}

