/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.endurance;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.endurance.EnduranceSource;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class EnduranceLeveler
extends SkillLeveler
implements Listener {
    public EnduranceLeveler(AureliumSkills plugin) {
        super(plugin, Ability.RUNNER);
    }

    public void startTracking() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (OptionL.isEnabled(Skills.ENDURANCE)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.plugin.getPlayerManager().hasPlayerData(player)) continue;
                    int xpAmount = 0;
                    if (player.hasMetadata("skillsLastSprintDist")) {
                        int sprintDist = player.getStatistic(Statistic.SPRINT_ONE_CM) - ((MetadataValue)player.getMetadata("skillsLastSprintDist").get(0)).asInt();
                        if (sprintDist > 1000) {
                            xpAmount = (int)((double)xpAmount + (double)(sprintDist / 100) * this.getXp(player, EnduranceSource.SPRINT_PER_METER));
                            player.setMetadata("skillsLastSprintDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.SPRINT_ONE_CM)));
                        }
                    } else {
                        player.setMetadata("skillsLastSprintDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.SPRINT_ONE_CM)));
                    }
                    if (player.hasMetadata("skillsLastWalkDist")) {
                        int walkDist = player.getStatistic(Statistic.WALK_ONE_CM) - ((MetadataValue)player.getMetadata("skillsLastWalkDist").get(0)).asInt();
                        if (walkDist > 100) {
                            xpAmount = (int)((double)xpAmount + (double)(walkDist / 100) * this.getXp(player, EnduranceSource.WALK_PER_METER));
                            player.setMetadata("skillsLastWalkDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.WALK_ONE_CM)));
                        }
                    } else {
                        player.setMetadata("skillsLastWalkDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.WALK_ONE_CM)));
                    }
                    if (player.hasMetadata("skillsLastSwimDist")) {
                        int swimDist = player.getStatistic(Statistic.SWIM_ONE_CM) - ((MetadataValue)player.getMetadata("skillsLastSwimDist").get(0)).asInt();
                        if (swimDist > 1000) {
                            xpAmount = (int)((double)xpAmount + (double)(swimDist / 100) * this.getXp(player, EnduranceSource.SWIM_PER_METER));
                            player.setMetadata("skillsLastSwimDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.SWIM_ONE_CM)));
                        }
                    } else {
                        player.setMetadata("skillsLastSwimDist", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getStatistic(Statistic.SWIM_ONE_CM)));
                    }
                    if (xpAmount <= 0) continue;
                    if (this.blockXpGain(player)) {
                        return;
                    }
                    if (player.getGameMode() == GameMode.SPECTATOR) {
                        return;
                    }
                    this.plugin.getLeveler().addXp(player, Skills.ENDURANCE, xpAmount);
                }
            }
        }, 0L, 2400L);
    }
}

