/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.endurance;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.CustomRegenEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import java.util.Random;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class EnduranceAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public EnduranceAbilities(AureliumSkills plugin) {
        super(plugin, Skills.ENDURANCE);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void antiHunger(FoodLevelChangeEvent event) {
        if (this.blockDisabled(Ability.ANTI_HUNGER)) {
            return;
        }
        if (!event.isCancelled() && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            if (player.getFoodLevel() > event.getFoodLevel()) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                double chance = this.getValue(Ability.ANTI_HUNGER, playerData) / 100.0;
                if (this.r.nextDouble() < chance) {
                    event.setFoodLevel(player.getFoodLevel());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void goldenHealAndRecovery(EntityRegainHealthEvent event) {
        if (OptionL.isEnabled(Skills.ENDURANCE) && !event.isCancelled() && event.getEntity() instanceof Player) {
            double maxHealth;
            double currentHealth;
            AttributeInstance attribute;
            Player player = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (event.getRegainReason().equals((Object)EntityRegainHealthEvent.RegainReason.MAGIC_REGEN)) {
                if (this.isEnabled(Ability.GOLDEN_HEAL)) {
                    double modifier = this.getValue(Ability.GOLDEN_HEAL, playerData) / 100.0;
                    event.setAmount(event.getAmount() * (1.0 + modifier));
                }
            } else if (event.getRegainReason().equals((Object)EntityRegainHealthEvent.RegainReason.SATIATED) && this.isEnabled(Ability.RECOVERY) && (attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH)) != null && (currentHealth = player.getHealth()) < (maxHealth = attribute.getValue()) / 2.0) {
                double modifier = this.getValue(Ability.RECOVERY, playerData) / 100.0;
                event.setAmount(event.getAmount() * (1.0 + modifier));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void recoveryCustom(CustomRegenEvent event) {
        if (!event.isCancelled() && this.isEnabled(Ability.RECOVERY)) {
            double maxHealth;
            double currentHealth;
            Player player = event.getPlayer();
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attribute != null && (currentHealth = player.getHealth()) < (maxHealth = attribute.getValue()) / 2.0) {
                double modifier = this.getValue(Ability.RECOVERY, playerData) / 100.0;
                event.setAmount(event.getAmount() * (1.0 + modifier));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void mealSteal(EntityDamageByEntityEvent event) {
        if (this.blockDisabled(Ability.MEAL_STEAL)) {
            return;
        }
        if (!event.isCancelled() && event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            Player enemy = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            double chance = this.getValue(Ability.MEAL_STEAL, playerData) / 100.0;
            if (this.r.nextDouble() < chance) {
                if (enemy.getFoodLevel() >= 1) {
                    enemy.setFoodLevel(enemy.getFoodLevel() - 1);
                }
                if (player.getFoodLevel() < 20) {
                    player.setFoodLevel(player.getFoodLevel() + 1);
                } else if (player.getSaturation() < 20.0f) {
                    player.setSaturation(player.getSaturation() + 1.0f);
                }
            }
        }
    }
}

