/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.enchanting;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.enchanting.EnchantingSource;
import com.archyx.aureliumskills.util.item.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class EnchantingLeveler
extends SkillLeveler
implements Listener {
    public EnchantingLeveler(AureliumSkills plugin) {
        super(plugin, Ability.ENCHANTER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnchant(EnchantItemEvent event) {
        if (OptionL.isEnabled(Skills.ENCHANTING)) {
            if (OptionL.getBoolean(Option.ENCHANTING_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            Player p = event.getEnchanter();
            if (this.blockXpGainLocation(event.getEnchantBlock().getLocation(), p)) {
                return;
            }
            Material mat = event.getItem().getType();
            if (this.blockXpGainPlayer(p)) {
                return;
            }
            if (ItemUtils.isArmor(mat)) {
                this.plugin.getLeveler().addXp(p, Skills.ENCHANTING, (double)event.getExpLevelCost() * this.getXp(p, EnchantingSource.ARMOR_PER_LEVEL));
            } else if (ItemUtils.isWeapon(mat)) {
                this.plugin.getLeveler().addXp(p, Skills.ENCHANTING, (double)event.getExpLevelCost() * this.getXp(p, EnchantingSource.WEAPON_PER_LEVEL));
            } else if (mat.equals((Object)Material.BOOK)) {
                this.plugin.getLeveler().addXp(p, Skills.ENCHANTING, (double)event.getExpLevelCost() * this.getXp(p, EnchantingSource.BOOK_PER_LEVEL));
            } else {
                this.plugin.getLeveler().addXp(p, Skills.ENCHANTING, (double)event.getExpLevelCost() * this.getXp(p, EnchantingSource.TOOL_PER_LEVEL));
            }
        }
    }
}

