/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.enchanting;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.XpGainEvent;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stats;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EnchantingAbilities
extends AbilityProvider
implements Listener {
    private final Random random = new Random();

    public EnchantingAbilities(AureliumSkills plugin) {
        super(plugin, Skills.ENCHANTING);
        this.enchantedStrength();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void xpConvert(XpGainEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.blockDisabled(Ability.XP_CONVERT)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null && playerData.getAbilityLevel(Ability.XP_CONVERT) > 0 && event.getAmount() > 0.0) {
            double totalXp = playerData.getAbilityData(Ability.XP_CONVERT).getDouble("xp") + event.getAmount();
            double value = this.getValue(Ability.XP_CONVERT, playerData);
            if (value > 0.0) {
                int added = (int)(totalXp / value);
                double remainder = totalXp - (double)added * value;
                player.giveExp(added);
                playerData.getAbilityData(Ability.XP_CONVERT).setData("xp", remainder);
            }
        }
    }

    @EventHandler
    public void xpWarrior(EntityDeathEvent event) {
        if (this.blockDisabled(Ability.XP_WARRIOR)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() != null) {
            Player player = entity.getKiller();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData != null && playerData.getAbilityLevel(Ability.XP_WARRIOR) > 0 && event.getDroppedExp() > 0 && this.random.nextDouble() < this.getValue(Ability.XP_WARRIOR, playerData) / 100.0) {
                event.setDroppedExp(event.getDroppedExp() * 2);
            }
        }
    }

    private void enchantedStrength() {
        new BukkitRunnable(){

            public void run() {
                if (EnchantingAbilities.this.blockDisabled(Ability.ENCHANTED_STRENGTH)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PlayerData playerData = EnchantingAbilities.this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null || playerData.getAbilityLevel(Ability.ENCHANTED_STRENGTH) <= 0) continue;
                    ItemStack item = player.getInventory().getItemInMainHand();
                    if (item.getEnchantments().size() > 0) {
                        if (EnchantingAbilities.this.blockAbility(player)) continue;
                        double strengthPerType = EnchantingAbilities.this.getValue(Ability.ENCHANTED_STRENGTH, playerData);
                        StatModifier modifier = new StatModifier("AbilityModifier-EnchantedStrength", Stats.STRENGTH, strengthPerType * (double)item.getEnchantments().size());
                        playerData.addStatModifier(modifier, false);
                        continue;
                    }
                    playerData.removeStatModifier("AbilityModifier-EnchantedStrength");
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 10L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void luckyTable(EnchantItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.blockDisabled(Ability.LUCKY_TABLE)) {
            return;
        }
        Player player = event.getEnchanter();
        if (this.blockAbility(player)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.getAbilityLevel(Ability.LUCKY_TABLE) > 0) {
            for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                if (((Enchantment)entry.getKey()).getMaxLevel() <= (Integer)entry.getValue() || !(this.random.nextDouble() < this.getValue(Ability.LUCKY_TABLE, playerData) / 100.0)) continue;
                entry.setValue((Integer)entry.getValue() + 1);
            }
        }
    }
}

