/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.defense;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skills;
import java.util.Random;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class DefenseAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public DefenseAbilities(AureliumSkills plugin) {
        super(plugin, Skills.DEFENSE);
    }

    public void shielding(EntityDamageByEntityEvent event, PlayerData playerData, Player player) {
        if (this.plugin.getAbilityManager().isEnabled(Ability.SHIELDING) && player.isSneaking() && playerData.getAbilityLevel(Ability.SHIELDING) > 0) {
            double damageReduction = 1.0 - this.getValue(Ability.SHIELDING, playerData) / 100.0;
            event.setDamage(event.getDamage() * damageReduction);
        }
    }

    public void mobMaster(EntityDamageByEntityEvent event, PlayerData playerData) {
        if (this.plugin.getAbilityManager().isEnabled(Ability.MOB_MASTER) && event.getDamager() instanceof LivingEntity && !(event.getDamager() instanceof Player) && playerData.getAbilityLevel(Ability.MOB_MASTER) > 0) {
            double damageReduction = 1.0 - this.getValue(Ability.MOB_MASTER, playerData) / 100.0;
            event.setDamage(event.getDamage() * damageReduction);
        }
    }

    public void immunity(EntityDamageByEntityEvent event, PlayerData playerData) {
        double chance = this.getValue(Ability.IMMUNITY, playerData) / 100.0;
        if (this.r.nextDouble() < chance) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void noDebuff(PotionSplashEvent event) {
        if (this.blockDisabled(Ability.NO_DEBUFF)) {
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (this.blockAbility(player)) {
                return;
            }
            for (PotionEffect effect : event.getPotion().getEffects()) {
                PotionEffectType type = effect.getType();
                if (!type.equals((Object)PotionEffectType.POISON) && !type.equals((Object)PotionEffectType.UNLUCK) && !type.equals((Object)PotionEffectType.WITHER) && !type.equals((Object)PotionEffectType.WEAKNESS) && !type.equals((Object)PotionEffectType.SLOW_DIGGING) && !type.equals((Object)PotionEffectType.SLOW) && !type.equals((Object)PotionEffectType.HUNGER) && !type.equals((Object)PotionEffectType.HARM) && !type.equals((Object)PotionEffectType.CONFUSION) && !type.equals((Object)PotionEffectType.BLINDNESS)) continue;
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                double chance = this.getValue(Ability.NO_DEBUFF, playerData) / 100.0;
                if (!(this.r.nextDouble() < chance) || player.hasPotionEffect(type)) continue;
                event.setIntensity(entity, 0.0);
            }
        }
    }

    public void noDebuffFire(PlayerData playerData, final Player player, LivingEntity entity) {
        ItemStack item;
        if (entity.getEquipment() != null && (item = entity.getEquipment().getItemInMainHand()) != null && item.getEnchantmentLevel(Enchantment.FIRE_ASPECT) > 0) {
            double chance = this.getValue(Ability.NO_DEBUFF, playerData) / 100.0;
            if (this.r.nextDouble() < chance) {
                new BukkitRunnable(){

                    public void run() {
                        player.setFireTicks(0);
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
            }
        }
    }

    @EventHandler
    public void defenseListener(EntityDamageByEntityEvent event) {
        if (OptionL.isEnabled(Skills.DEFENSE) && !event.isCancelled() && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (this.plugin.getAbilityManager().isEnabled(Ability.NO_DEBUFF) && event.getDamager() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)event.getDamager();
                this.noDebuffFire(playerData, player, entity);
            }
            if (this.plugin.getAbilityManager().isEnabled(Ability.IMMUNITY)) {
                this.immunity(event, playerData);
            }
        }
    }
}

