/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.archery;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.archery.ArcherySource;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class ArcheryLeveler
extends SkillLeveler
implements Listener {
    public ArcheryLeveler(AureliumSkills plugin) {
        super(plugin, Ability.ARCHER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        block14: {
            if (OptionL.isEnabled(Skills.ARCHERY)) {
                EntityDamageByEntityEvent ee;
                if (OptionL.getBoolean(Option.ARCHERY_DAMAGE_BASED)) {
                    return;
                }
                LivingEntity e = event.getEntity();
                if (e.getKiller() != null && e.getLastDamageCause() instanceof EntityDamageByEntityEvent && (ee = (EntityDamageByEntityEvent)e.getLastDamageCause()).getDamager() instanceof Projectile) {
                    EntityType type = e.getType();
                    Player p = e.getKiller();
                    Skills skill = Skills.ARCHERY;
                    if (ee.getDamager() instanceof ThrownPotion) {
                        if (OptionL.getBoolean(Option.ALCHEMY_GIVE_XP_ON_POTION_COMBAT)) {
                            skill = Skills.ALCHEMY;
                        } else {
                            return;
                        }
                    }
                    if (this.blockXpGainLocation(e.getLocation(), p)) {
                        return;
                    }
                    if (this.blockXpGainPlayer(p)) {
                        return;
                    }
                    if (e.equals(p)) {
                        return;
                    }
                    double spawnerMultiplier = OptionL.getDouble(Option.ARCHERY_SPAWNER_MULTIPLIER);
                    try {
                        if (e.hasMetadata("aureliumskills_spawner_mob")) {
                            this.plugin.getLeveler().addXp(p, skill, spawnerMultiplier * this.getXp(p, ArcherySource.valueOf(type.toString())));
                        } else {
                            this.plugin.getLeveler().addXp(p, skill, this.getXp(p, ArcherySource.valueOf(type.toString())));
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        if (!type.toString().equals("PIG_ZOMBIE")) break block14;
                        if (e.hasMetadata("aureliumskills_spawner_mob")) {
                            this.plugin.getLeveler().addXp(p, skill, spawnerMultiplier * this.getXp(p, ArcherySource.ZOMBIFIED_PIGLIN));
                        }
                        this.plugin.getLeveler().addXp(p, skill, this.getXp(p, ArcherySource.ZOMBIFIED_PIGLIN));
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        block15: {
            if (OptionL.isEnabled(Skills.ARCHERY)) {
                if (event.isCancelled()) {
                    return;
                }
                if (!OptionL.getBoolean(Option.ARCHERY_DAMAGE_BASED)) {
                    return;
                }
                if (event.getDamager() instanceof Projectile) {
                    Projectile projectile = (Projectile)event.getDamager();
                    Skills skill = Skills.ARCHERY;
                    if (projectile instanceof ThrownPotion) {
                        if (OptionL.getBoolean(Option.ALCHEMY_GIVE_XP_ON_POTION_COMBAT)) {
                            skill = Skills.ALCHEMY;
                        } else {
                            return;
                        }
                    }
                    if (projectile.getShooter() instanceof Player) {
                        Player player = (Player)projectile.getShooter();
                        if (event.getEntity() instanceof LivingEntity) {
                            LivingEntity entity = (LivingEntity)event.getEntity();
                            if (this.blockXpGainLocation(entity.getLocation(), player)) {
                                return;
                            }
                            EntityType type = entity.getType();
                            if (this.blockXpGainPlayer(player)) {
                                return;
                            }
                            if (entity.equals(player)) {
                                return;
                            }
                            double health = entity.getHealth();
                            double damage = Math.min(health, event.getFinalDamage());
                            if (entity.hasMetadata("aureliumskills_spawner_mob")) {
                                double spawnerMultiplier = OptionL.getDouble(Option.ARCHERY_SPAWNER_MULTIPLIER);
                                damage *= spawnerMultiplier;
                            }
                            try {
                                this.plugin.getLeveler().addXp(player, skill, damage * this.getXp(player, ArcherySource.valueOf(type.toString())));
                            }
                            catch (IllegalArgumentException e) {
                                if (!type.toString().equals("PIG_ZOMBIE")) break block15;
                                this.plugin.getLeveler().addXp(player, skill, damage * this.getXp(player, ArcherySource.ZOMBIFIED_PIGLIN));
                            }
                        }
                    }
                }
            }
        }
    }
}

