/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.alchemy;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.Leveler;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.region.BlockPosition;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.alchemy.AlchemySource;
import com.archyx.aureliumskills.skills.alchemy.BrewingStandData;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AlchemyLeveler
extends SkillLeveler
implements Listener {
    private final Map<BlockPosition, BrewingStandData> brewingStands = new HashMap<BlockPosition, BrewingStandData>();

    public AlchemyLeveler(AureliumSkills plugin) {
        super(plugin, Ability.BREWER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBrew(BrewEvent event) {
        Player player;
        OfflinePlayer offlinePlayer;
        if (!OptionL.isEnabled(Skills.ALCHEMY)) {
            return;
        }
        if (OptionL.getBoolean(Option.ALCHEMY_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        if (OptionL.getBoolean(Option.ALCHEMY_GIVE_XP_ON_TAKEOUT)) {
            this.checkBrewedSlots(event);
        } else if (event.getBlock().hasMetadata("skillsBrewingStandOwner") && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(((MetadataValue)event.getBlock().getMetadata("skillsBrewingStandOwner").get(0)).asString()))).isOnline() && event.getContents().getIngredient() != null && (player = offlinePlayer.getPlayer()) != null) {
            if (this.blockXpGainLocation(event.getBlock().getLocation(), player)) {
                return;
            }
            if (this.blockXpGainPlayer(player)) {
                return;
            }
            this.addAlchemyXp(player, event.getContents().getIngredient().getType());
        }
    }

    private void addAlchemyXp(Player player, Material mat) {
        Leveler leveler = this.plugin.getLeveler();
        if (mat.equals((Object)Material.REDSTONE)) {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.EXTENDED));
        } else if (mat.equals((Object)Material.GLOWSTONE_DUST)) {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.UPGRADED));
        } else if (mat.equals((Object)XMaterial.NETHER_WART.parseMaterial())) {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.AWKWARD));
        } else if (mat.equals((Object)XMaterial.GUNPOWDER.parseMaterial())) {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.SPLASH));
        } else if (mat.equals((Object)XMaterial.DRAGON_BREATH.parseMaterial())) {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.LINGERING));
        } else {
            leveler.addXp(player, Skills.ALCHEMY, this.getXp(player, AlchemySource.REGULAR));
        }
    }

    private void checkBrewedSlots(final BrewEvent event) {
        BrewerInventory before = event.getContents();
        ItemStack ingredient = before.getIngredient();
        if (ingredient == null) {
            return;
        }
        final ItemStack clonedIngredient = ingredient.clone();
        final ItemStack[] beforeItems = Arrays.copyOf(before.getContents(), 3);
        new BukkitRunnable(){

            public void run() {
                BlockState blockState = event.getBlock().getState();
                if (blockState instanceof BrewingStand) {
                    BrewingStand brewingStand = (BrewingStand)blockState;
                    BrewerInventory after = brewingStand.getInventory();
                    ItemStack[] afterItems = Arrays.copyOf(after.getContents(), 3);
                    BrewingStandData standData = new BrewingStandData(clonedIngredient);
                    for (int i = 0; i < 3; ++i) {
                        ItemStack beforeItem = beforeItems[i];
                        ItemStack afterItem = afterItems[i];
                        if (beforeItem == null || beforeItem.getType() == Material.AIR || afterItem == null || afterItem.getType() == Material.AIR || beforeItem.equals((Object)afterItem)) continue;
                        standData.setSlotBrewed(i, true);
                    }
                    AlchemyLeveler.this.brewingStands.put(BlockPosition.fromBlock(event.getBlock()), standData);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType().equals((Object)Material.BREWING_STAND) && OptionL.isEnabled(Skills.ALCHEMY)) {
            event.getBlock().setMetadata("skillsBrewingStandOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getUniqueId()));
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
            if (OptionL.isEnabled(Skills.ALCHEMY) && event.getBlock().hasMetadata("skillsBrewingStandOwner")) {
                event.getBlock().removeMetadata("skillsBrewingStandOwner", (Plugin)this.plugin);
            }
            this.brewingStands.remove(BlockPosition.fromBlock(event.getBlock()));
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Block block;
        if (event.getInventory().getType().equals((Object)InventoryType.BREWING) && OptionL.isEnabled(Skills.ALCHEMY) && event.getInventory().getHolder() != null && event.getInventory().getLocation() != null && !(block = event.getInventory().getLocation().getBlock()).hasMetadata("skillsBrewingStandOwner")) {
            block.setMetadata("skillsBrewingStandOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getUniqueId()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTakePotionOut(InventoryClickEvent event) {
        if (!OptionL.isEnabled(Skills.ALCHEMY)) {
            return;
        }
        if (!OptionL.getBoolean(Option.ALCHEMY_GIVE_XP_ON_TAKEOUT)) {
            return;
        }
        if (OptionL.getBoolean(Option.ALCHEMY_CHECK_CANCELLED) && event.isCancelled()) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        if (inventory.getType() != InventoryType.BREWING && !(inventory instanceof BrewerInventory)) {
            return;
        }
        int slot = event.getSlot();
        if (slot > 2) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action != InventoryAction.PICKUP_ALL && action != InventoryAction.PICKUP_HALF && action != InventoryAction.PICKUP_SOME && action != InventoryAction.PICKUP_ONE && action != InventoryAction.MOVE_TO_OTHER_INVENTORY && action != InventoryAction.HOTBAR_SWAP && action != InventoryAction.HOTBAR_MOVE_AND_READD) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        Location location = inventory.getLocation();
        if (location == null) {
            return;
        }
        BrewingStandData standData = this.brewingStands.get(BlockPosition.fromBlock(location.getBlock()));
        if (standData == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.blockXpGainLocation(location, player)) {
            return;
        }
        if (this.blockXpGainPlayer(player)) {
            return;
        }
        if (!standData.isSlotBrewed(slot)) {
            return;
        }
        ItemStack ingredient = standData.getIngredient();
        if (ingredient == null) {
            return;
        }
        if (ingredient.getType() == Material.AIR) {
            return;
        }
        this.addAlchemyXp(player, ingredient.getType());
        standData.setSlotBrewed(slot, false);
    }
}

