/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.alchemy;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.AbilityMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTItem;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.agility.AgilityAbilities;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.mechanics.PotionUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.util.version.VersionUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class AlchemyAbilities
extends AbilityProvider
implements Listener {
    private final AgilityAbilities agilityAbilities;

    public AlchemyAbilities(AureliumSkills plugin) {
        super(plugin, Skills.ALCHEMY);
        this.agilityAbilities = new AgilityAbilities(plugin);
        this.wiseEffect();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void alchemist(BrewEvent event) {
        OfflinePlayer offlinePlayer;
        if (this.blockDisabled(Ability.ALCHEMIST)) {
            return;
        }
        if (!event.isCancelled() && event.getBlock().hasMetadata("skillsBrewingStandOwner") && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(((MetadataValue)event.getBlock().getMetadata("skillsBrewingStandOwner").get(0)).asString()))).isOnline()) {
            Player player = offlinePlayer.getPlayer();
            BrewerInventory inventory = event.getContents();
            if (player != null) {
                if (this.blockAbility(player)) {
                    return;
                }
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                if (playerData.getAbilityLevel(Ability.ALCHEMIST) > 0) {
                    this.updateBrewingStand(inventory, playerData, playerData.getLocale());
                }
            }
        }
    }

    private void updateBrewingStand(final BrewerInventory inventory, final PlayerData playerData, final Locale locale) {
        new BukkitRunnable(){

            public void run() {
                ItemStack[] contents = inventory.getContents();
                double multiplier = 1.0 + AlchemyAbilities.this.getValue(Ability.ALCHEMIST, playerData) / 100.0;
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack item = contents[i];
                    if (item == null || !(item.getItemMeta() instanceof PotionMeta)) continue;
                    contents[i] = AlchemyAbilities.this.applyDurationData(item, multiplier, locale);
                }
                inventory.setContents(contents);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private boolean isApplicablePotion(PotionType potionType) {
        switch (potionType) {
            case INSTANT_DAMAGE: 
            case INSTANT_HEAL: 
            case AWKWARD: 
            case MUNDANE: 
            case THICK: 
            case WATER: {
                return false;
            }
        }
        return true;
    }

    private ItemStack applyDurationData(ItemStack originalItem, double multiplier, Locale locale) {
        PotionData potionData;
        PotionMeta potionMeta = (PotionMeta)originalItem.getItemMeta();
        if (potionMeta != null && this.isApplicablePotion((potionData = potionMeta.getBasePotionData()).getType())) {
            int originalDuration = PotionUtil.getDuration(potionData);
            int duration = (int)((double)originalDuration * multiplier);
            int durationBonus = duration - originalDuration;
            NBTItem nbtItem = new NBTItem(originalItem);
            NBTCompound nbtCompound = nbtItem.getCompound("skillsPotion");
            if (nbtCompound == null) {
                nbtItem.addCompound("skillsPotion").setInteger("durationBonus", durationBonus);
            }
            if (nbtCompound != null) {
                nbtCompound.setInteger("durationBonus", durationBonus);
            }
            ItemStack item = nbtItem.getItem();
            ItemMeta meta = item.getItemMeta();
            if (duration != 0 && meta != null && this.plugin.getAbilityManager().getOptionAsBooleanElseTrue(Ability.ALCHEMIST, "add_item_lore")) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(TextUtil.replace(Lang.getMessage(AbilityMessage.ALCHEMIST_LORE, locale), "{duration}", PotionUtil.formatDuration(durationBonus), "{value}", NumberUtil.format1((multiplier - 1.0) * 100.0)));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            return item;
        }
        return originalItem;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrink(PlayerItemConsumeEvent event) {
        PotionData potionData;
        PotionType potionType;
        PotionEffectType effectType;
        PotionMeta meta;
        Integer durationBonus;
        NBTItem nbtItem;
        NBTCompound compound;
        if (this.blockDisabled(Ability.ALCHEMIST)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getItem();
        if (item.getType() == Material.POTION && item.getItemMeta() instanceof PotionMeta && (compound = (nbtItem = new NBTItem(item)).getCompound("skillsPotion")) != null && (durationBonus = compound.getInteger("durationBonus")) != null && (meta = (PotionMeta)item.getItemMeta()) != null && (effectType = (potionType = (potionData = meta.getBasePotionData()).getType()).getEffectType()) != null) {
            if (!potionType.toString().equals("TURTLE_MASTER")) {
                int amplifier = 0;
                if (potionData.isUpgraded()) {
                    amplifier = potionType.equals((Object)PotionType.SLOWNESS) ? 3 : 1;
                }
                if (effectType.equals((Object)PotionEffectType.SPEED) || effectType.equals((Object)PotionEffectType.JUMP)) {
                    PotionUtil.applyEffect(player, new PotionEffect(effectType, (int)((double)(PotionUtil.getDuration(potionData) + durationBonus) * this.agilityAbilities.getSugarRushSplashMultiplier(player)), amplifier));
                } else {
                    PotionUtil.applyEffect(player, new PotionEffect(effectType, PotionUtil.getDuration(potionData) + durationBonus, amplifier));
                }
            } else if (!potionData.isUpgraded()) {
                PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.SLOW, PotionUtil.getDuration(potionData) + durationBonus, 3));
                PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, PotionUtil.getDuration(potionData) + durationBonus, 2));
            } else {
                PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.SLOW, PotionUtil.getDuration(potionData) + durationBonus, 5));
                PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, PotionUtil.getDuration(potionData) + durationBonus, 3));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSplash(PotionSplashEvent event) {
        if (this.blockDisabled(Ability.ALCHEMIST)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getPotion().getItem();
        if (item.getItemMeta() instanceof PotionMeta && item.getItemMeta() != null) {
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            PotionData potionData = meta.getBasePotionData();
            if (meta.hasCustomEffects() && OptionL.getBoolean(Option.ALCHEMY_IGNORE_CUSTOM_POTIONS)) {
                return;
            }
            NBTItem nbtItem = new NBTItem(item);
            int durationBonus = 0;
            NBTCompound compound = nbtItem.getCompound("skillsPotion");
            if (compound != null) {
                durationBonus = compound.getInteger("durationBonus");
            }
            for (PotionEffect effect : event.getPotion().getEffects()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (this.blockAbility(player)) {
                        return;
                    }
                    double splasherMultiplier = this.getSplasherMultiplier(event.getPotion().getShooter(), event.getAffectedEntities());
                    double intensity = event.getIntensity((LivingEntity)player);
                    int duration = (int)((double)(PotionUtil.getDuration(potionData) + durationBonus) * splasherMultiplier * intensity);
                    if (!potionData.getType().toString().equals("TURTLE_MASTER")) {
                        if (effect.getType().equals((Object)PotionEffectType.SPEED) || effect.getType().equals((Object)PotionEffectType.JUMP)) {
                            PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)duration * this.agilityAbilities.getSugarRushSplashMultiplier(player)), effect.getAmplifier()));
                            continue;
                        }
                        PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), duration, effect.getAmplifier()));
                        continue;
                    }
                    if (!potionData.isUpgraded()) {
                        PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.SLOW, duration, 3));
                        PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, duration, 2));
                        continue;
                    }
                    PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.SLOW, duration, 5));
                    PotionUtil.applyEffect(player, new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, duration, 3));
                }
            }
        }
    }

    private double getSplasherMultiplier(ProjectileSource source, Collection<LivingEntity> affectedEntities) {
        double splasherMultiplier = 1.0;
        if (source instanceof Player) {
            Player player = (Player)source;
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData != null && this.plugin.getAbilityManager().isEnabled(Ability.SPLASHER) && playerData.getAbilityLevel(Ability.SPLASHER) > 0) {
                double splasherPercent = this.getValue(Ability.SPLASHER, playerData);
                int affectedPlayers = (int)affectedEntities.stream().filter(entity -> entity instanceof Player).filter(entity -> this.plugin.getPlayerManager().getPlayerData(entity.getUniqueId()) != null).count();
                splasherMultiplier = 1.0 + splasherPercent / 100.0 * (double)affectedPlayers;
            }
        }
        return splasherMultiplier;
    }

    @EventHandler
    public void lingering(LingeringPotionSplashEvent event) {
        if (this.blockDisabled(Ability.LINGERING)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = null;
        if (VersionUtils.isAtLeastVersion(14)) {
            if (event.getEntity().getShooter() instanceof Player) {
                player = (Player)event.getEntity().getShooter();
            }
        } else {
            try {
                LingeringPotion lingeringPotion;
                Object lingeringPotionObject = event.getClass().getDeclaredMethod("getEntity", new Class[0]).invoke((Object)event, new Object[0]);
                if (lingeringPotionObject instanceof LingeringPotion && (lingeringPotion = (LingeringPotion)lingeringPotionObject).getShooter() instanceof Player) {
                    player = (Player)lingeringPotion.getShooter();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException lingeringPotionObject) {
                // empty catch block
            }
        }
        if (player != null) {
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.LINGERING) > 0) {
                AreaEffectCloud cloud = event.getAreaEffectCloud();
                if (cloud.hasCustomEffects() && OptionL.getBoolean(Option.ALCHEMY_IGNORE_CUSTOM_POTIONS)) {
                    return;
                }
                double naturalDecay = 1.0 - this.getValue(Ability.LINGERING, playerData) / 100.0;
                double entityDecay = 1.0 - this.getValue2(Ability.LINGERING, playerData) / 100.0;
                if (naturalDecay <= 0.01) {
                    naturalDecay = 0.01;
                }
                if (entityDecay <= 0.01) {
                    entityDecay = 0.01;
                }
                cloud.setRadiusPerTick(cloud.getRadiusPerTick() * (float)naturalDecay);
                cloud.setRadiusOnUse(cloud.getRadiusOnUse() * (float)entityDecay);
            }
        }
    }

    private void wiseEffect() {
        new BukkitRunnable(){

            public void run() {
                if (!AlchemyAbilities.this.blockDisabled(Ability.WISE_EFFECT)) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        PlayerData playerData = AlchemyAbilities.this.plugin.getPlayerManager().getPlayerData(player);
                        if (playerData == null) continue;
                        if (player.getActivePotionEffects().size() > 0) {
                            if (playerData.getAbilityLevel(Ability.WISE_EFFECT) <= 0 || AlchemyAbilities.this.blockAbility(player)) continue;
                            HashSet<PotionEffectType> uniqueTypesSet = new HashSet<PotionEffectType>();
                            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                                uniqueTypesSet.add(potionEffect.getType());
                            }
                            int uniqueTypes = uniqueTypesSet.size();
                            double wisdomPerType = AlchemyAbilities.this.getValue(Ability.WISE_EFFECT, playerData);
                            double modifierValue = wisdomPerType * (double)uniqueTypes;
                            if (!(modifierValue > 0.0)) continue;
                            StatModifier modifier = new StatModifier("AbilityModifier-WiseEffect", Stats.WISDOM, modifierValue);
                            playerData.addStatModifier(modifier, false);
                            continue;
                        }
                        playerData.removeStatModifier("AbilityModifier-WiseEffect", false);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 10L);
    }
}

