/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.agility;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.leveler.SkillLeveler;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.agility.AgilitySource;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AgilityLeveler
extends SkillLeveler
implements Listener {
    private final Set<UUID> prevPlayersOnGround = Sets.newHashSet();

    public AgilityLeveler(AureliumSkills plugin) {
        super(plugin, Ability.JUMPER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFall(EntityDamageEvent event) {
        if (OptionL.isEnabled(Skills.AGILITY)) {
            if (OptionL.getBoolean(Option.AGILITY_CHECK_CANCELLED) && event.isCancelled()) {
                return;
            }
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL) && event.getEntity() instanceof Player) {
                Player player = (Player)event.getEntity();
                if (this.blockXpGain(player)) {
                    return;
                }
                if (event.getFinalDamage() < player.getHealth()) {
                    this.plugin.getLeveler().addXp(player, Skills.AGILITY, this.getXp(player, event.getOriginalDamage(EntityDamageEvent.DamageModifier.BASE) * this.getXp(AgilitySource.FALL_DAMAGE)));
                }
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (OptionL.isEnabled(Skills.AGILITY)) {
            if (OptionL.getBoolean(Option.AGILITY_CHECK_CANCELLED) && e.isCancelled()) {
                return;
            }
            Player player = e.getPlayer();
            if (player.getVelocity().getY() > 0.0) {
                PotionEffect effect;
                double jumpVelocity = 0.42f;
                if (player.hasPotionEffect(PotionEffectType.JUMP) && (effect = player.getPotionEffect(PotionEffectType.JUMP)) != null) {
                    jumpVelocity += (double)((float)(effect.getAmplifier() + 1) * 0.1f);
                }
                if (e.getPlayer().getLocation().getBlock().getType() != Material.LADDER && this.prevPlayersOnGround.contains(player.getUniqueId()) && !player.isOnGround() && Double.compare(player.getVelocity().getY(), jumpVelocity) == 0) {
                    if (player.hasMetadata("skillsJumps")) {
                        player.setMetadata("skillsJumps", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)(((MetadataValue)player.getMetadata("skillsJumps").get(0)).asInt() + 1)));
                        if (((MetadataValue)player.getMetadata("skillsJumps").get(0)).asInt() >= 100) {
                            if (this.blockXpGain(player)) {
                                return;
                            }
                            this.plugin.getLeveler().addXp(player, Skills.AGILITY, this.getXp(player, AgilitySource.JUMP_PER_100));
                            player.removeMetadata("skillsJumps", (Plugin)this.plugin);
                        }
                    } else {
                        player.setMetadata("skillsJumps", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1));
                    }
                }
            }
            if (player.isOnGround()) {
                this.prevPlayersOnGround.add(player.getUniqueId());
            } else {
                this.prevPlayersOnGround.remove(player.getUniqueId());
            }
        }
    }
}

