/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills.agility;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.CustomRegenEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.configuration.OptionValue;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.lang.AbilityMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.mechanics.PotionUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class AgilityAbilities
extends AbilityProvider
implements Listener {
    private final Random r = new Random();

    public AgilityAbilities(AureliumSkills plugin) {
        super(plugin, Skills.AGILITY);
    }

    private void lightFall(EntityDamageEvent event, PlayerData playerData) {
        if (event.getFinalDamage() > 0.0) {
            double percentReduction = this.getValue(Ability.LIGHT_FALL, playerData);
            event.setDamage(event.getDamage() * (1.0 - percentReduction / 100.0));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void sugarRushSplash(PotionSplashEvent event) {
        if (!event.isCancelled()) {
            if (this.blockDisabled(Ability.SUGAR_RUSH)) {
                return;
            }
            for (PotionEffect effect : event.getPotion().getEffects()) {
                if (!effect.getType().equals((Object)PotionEffectType.SPEED) && !effect.getType().equals((Object)PotionEffectType.JUMP)) continue;
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (this.blockAbility(player)) {
                        return;
                    }
                    PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null) {
                        return;
                    }
                    if (playerData.getAbilityLevel(Ability.SUGAR_RUSH) <= 0) continue;
                    double intensity = event.getIntensity((LivingEntity)player);
                    double multiplier = 1.0 + this.getValue(Ability.SUGAR_RUSH, playerData) / 100.0;
                    PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)effect.getDuration() * multiplier * intensity), effect.getAmplifier()));
                }
            }
        }
    }

    public double getSugarRushSplashMultiplier(Player player) {
        PlayerData playerData;
        if (player.hasPermission("aureliumskills.agility") && this.plugin.getAbilityManager().isEnabled(Ability.SUGAR_RUSH) && (playerData = this.plugin.getPlayerManager().getPlayerData(player)) != null && playerData.getAbilityLevel(Ability.SUGAR_RUSH) > 0) {
            return 1.0 + this.getValue(Ability.SUGAR_RUSH, playerData) / 100.0;
        }
        return 1.0;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void sugarRushDrink(PlayerItemConsumeEvent event) {
        if (!event.isCancelled()) {
            ItemStack item;
            if (this.blockDisabled(Ability.SUGAR_RUSH)) {
                return;
            }
            Player player = event.getPlayer();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityLevel(Ability.SUGAR_RUSH) > 0 && (item = event.getItem()).getType() == Material.POTION && item.getItemMeta() instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                PotionData potion = meta.getBasePotionData();
                double multiplier = 1.0 + this.getValue(Ability.SUGAR_RUSH, playerData) / 100.0;
                if (potion.getType() == PotionType.SPEED || potion.getType() == PotionType.JUMP) {
                    int amplifier = 0;
                    if (potion.isUpgraded()) {
                        amplifier = 1;
                    }
                    PotionEffectType potionEffectType = potion.getType() == PotionType.SPEED ? PotionEffectType.SPEED : PotionEffectType.JUMP;
                    int duration = potion.isExtended() ? 480 : (potion.isUpgraded() ? 90 : 180);
                    duration = (int)(multiplier * (double)duration);
                    PotionUtil.applyEffect(player, new PotionEffect(potionEffectType, duration * 20, amplifier));
                }
                if (meta.hasCustomEffects()) {
                    for (PotionEffect effect : meta.getCustomEffects()) {
                        if (!effect.getType().equals((Object)PotionEffectType.SPEED) && !effect.getType().equals((Object)PotionEffectType.JUMP)) continue;
                        PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)effect.getDuration() * multiplier), effect.getAmplifier()));
                    }
                }
            }
        }
    }

    public void fleeting(EntityDamageEvent event, PlayerData playerData, Player player) {
        AttributeInstance attribute = Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH));
        double maxHealth = attribute.getValue();
        if (player.getHealth() - event.getFinalDamage() < this.getFleetingHealthRequired() * maxHealth && !player.hasMetadata("AureliumSkills-Fleeting")) {
            double percent = this.getValue(Ability.FLEETING, playerData);
            float boostFactor = 1.0f + (float)percent / 100.0f;
            float newSpeed = player.getWalkSpeed() * boostFactor;
            if (newSpeed > 1.0f) {
                newSpeed = 1.0f;
                percent = (newSpeed / player.getWalkSpeed() - 1.0f) * 100.0f;
            }
            float walkSpeedChange = newSpeed - player.getWalkSpeed();
            player.setWalkSpeed(newSpeed);
            player.setMetadata("AureliumSkills-Fleeting", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Float.valueOf(walkSpeedChange)));
            Locale locale = this.plugin.getLang().getLocale(player);
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(AbilityMessage.FLEETING_START, locale), "{value}", String.valueOf((int)percent)));
        }
    }

    public void removeFleeting(Player player) {
        AttributeInstance attribute = Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH));
        double maxHealth = attribute.getValue();
        if (player.getHealth() >= this.getFleetingHealthRequired() * maxHealth && player.hasMetadata("AureliumSkills-Fleeting")) {
            float walkSpeedChange = ((MetadataValue)player.getMetadata("AureliumSkills-Fleeting").get(0)).asFloat();
            player.setWalkSpeed(player.getWalkSpeed() - walkSpeedChange);
            player.removeMetadata("AureliumSkills-Fleeting", (Plugin)this.plugin);
            Locale locale = this.plugin.getLang().getLocale(player);
            this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.FLEETING_END, locale));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void fleetingEnd(EntityRegainHealthEvent event) {
        if (!event.isCancelled() && event.getEntity() instanceof Player) {
            this.fleetingRemove((Player)event.getEntity(), event.getAmount());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void fleetingEndCustom(CustomRegenEvent event) {
        if (!event.isCancelled()) {
            Player player = event.getPlayer();
            this.fleetingRemove(player, event.getAmount());
        }
    }

    public void fleetingRemove(Player player, double amountRegenerated) {
        if (this.blockAbility(player)) {
            return;
        }
        AttributeInstance attribute = Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH));
        double maxHealth = attribute.getValue();
        if (player.getHealth() + amountRegenerated >= this.getFleetingHealthRequired() * maxHealth && player.hasMetadata("AureliumSkills-Fleeting")) {
            float walkSpeedChange = ((MetadataValue)player.getMetadata("AureliumSkills-Fleeting").get(0)).asFloat();
            player.setWalkSpeed(player.getWalkSpeed() - walkSpeedChange);
            player.removeMetadata("AureliumSkills-Fleeting", (Plugin)this.plugin);
            Locale locale = this.plugin.getLang().getLocale(player);
            this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(AbilityMessage.FLEETING_END, locale));
        }
    }

    @EventHandler
    public void fleetingLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeFleetingQuit(player);
    }

    public void removeFleetingQuit(Player player) {
        if (player.hasMetadata("AureliumSkills-Fleeting")) {
            float walkSpeedChange = ((MetadataValue)player.getMetadata("AureliumSkills-Fleeting").get(0)).asFloat();
            player.setWalkSpeed(player.getWalkSpeed() - walkSpeedChange);
            player.removeMetadata("AureliumSkills-Fleeting", (Plugin)this.plugin);
        }
    }

    @EventHandler
    public void fleetingJoin(PlayerDataLoadEvent event) {
        if (!OptionL.isEnabled(Skills.AGILITY)) {
            return;
        }
        if (!this.plugin.getAbilityManager().isEnabled(Ability.FLEETING)) {
            return;
        }
        Player player = event.getPlayerData().getPlayer();
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        if (player.getHealth() < this.getFleetingHealthRequired() * attribute.getValue() && !player.hasMetadata("AureliumSkills-Fleeting")) {
            double percent = this.getValue(Ability.FLEETING, event.getPlayerData());
            float boostFactor = 1.0f + (float)percent / 100.0f;
            float newSpeed = player.getWalkSpeed() * boostFactor;
            if (newSpeed > 1.0f) {
                newSpeed = 1.0f;
            }
            float walkSpeedChange = newSpeed - player.getWalkSpeed();
            player.setWalkSpeed(newSpeed);
            player.setMetadata("AureliumSkills-Fleeting", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Float.valueOf(walkSpeedChange)));
        }
    }

    @EventHandler
    public void fleetingDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (player.hasMetadata("AureliumSkills-Fleeting")) {
            float walkSpeedChange = ((MetadataValue)player.getMetadata("AureliumSkills-Fleeting").get(0)).asFloat();
            player.setWalkSpeed(player.getWalkSpeed() - walkSpeedChange);
            player.removeMetadata("AureliumSkills-Fleeting", (Plugin)this.plugin);
        }
    }

    private double getFleetingHealthRequired() {
        double healthPercentRequired = 20.0;
        OptionValue optionValue = this.plugin.getAbilityManager().getOption(Ability.FLEETING, "health_percent_required");
        if (optionValue != null) {
            healthPercentRequired = optionValue.asDouble();
        }
        return healthPercentRequired / 100.0;
    }

    public void thunderFall(EntityDamageEvent event, PlayerData playerData, Player player) {
        if (player.isSneaking() && this.r.nextDouble() < this.getValue(Ability.THUNDER_FALL, playerData) / 100.0) {
            double percent = this.getValue2(Ability.THUNDER_FALL, playerData);
            double thunderFallDamage = percent / 100.0 * event.getDamage();
            for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 3.0, 3.0, 1.0)) {
                if (!(entity instanceof LivingEntity) || entity.equals(player)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.damage(thunderFallDamage, (Entity)player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void agilityListener(EntityDamageEvent event) {
        if (!event.isCancelled() && OptionL.isEnabled(Skills.AGILITY) && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                if (this.plugin.getAbilityManager().isEnabled(Ability.THUNDER_FALL) && playerData.getAbilityLevel(Ability.THUNDER_FALL) > 0) {
                    this.thunderFall(event, playerData, player);
                }
                if (this.plugin.getAbilityManager().isEnabled(Ability.LIGHT_FALL) && playerData.getAbilityLevel(Ability.LIGHT_FALL) > 0) {
                    this.lightFall(event, playerData);
                }
            }
            if (this.plugin.getAbilityManager().isEnabled(Ability.FLEETING) && playerData.getAbilityLevel(Ability.FLEETING) > 0) {
                this.fleeting(event, playerData, player);
            }
        }
    }
}

