/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.skills;

import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.SkillMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.skills.Skill;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public enum Skills implements Skill
{
    FARMING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.BOUNTIFUL_HARVEST, () -> Ability.FARMER, () -> Ability.SCYTHE_MASTER, () -> Ability.GENETICIST, () -> Ability.TRIPLE_HARVEST), MAbility.REPLENISH),
    FORAGING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.LUMBERJACK, () -> Ability.FORAGER, () -> Ability.AXE_MASTER, () -> Ability.VALOR, () -> Ability.SHREDDER), MAbility.TREECAPITATOR),
    MINING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.LUCKY_MINER, () -> Ability.MINER, () -> Ability.PICK_MASTER, () -> Ability.STAMINA, () -> Ability.HARDENED_ARMOR), MAbility.SPEED_MINE),
    FISHING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.LUCKY_CATCH, () -> Ability.FISHER, () -> Ability.TREASURE_HUNTER, () -> Ability.GRAPPLER, () -> Ability.EPIC_CATCH), MAbility.SHARP_HOOK),
    EXCAVATION((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.METAL_DETECTOR, () -> Ability.EXCAVATOR, () -> Ability.SPADE_MASTER, () -> Ability.BIGGER_SCOOP, () -> Ability.LUCKY_SPADES), MAbility.TERRAFORM),
    ARCHERY((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.CRIT_CHANCE, () -> Ability.ARCHER, () -> Ability.BOW_MASTER, () -> Ability.PIERCING, () -> Ability.STUN), MAbility.CHARGED_SHOT),
    DEFENSE((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.SHIELDING, () -> Ability.DEFENDER, () -> Ability.MOB_MASTER, () -> Ability.IMMUNITY, () -> Ability.NO_DEBUFF), MAbility.ABSORPTION),
    FIGHTING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.CRIT_DAMAGE, () -> Ability.FIGHTER, () -> Ability.SWORD_MASTER, () -> Ability.FIRST_STRIKE, () -> Ability.BLEED), MAbility.LIGHTNING_BLADE),
    ENDURANCE((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.ANTI_HUNGER, () -> Ability.RUNNER, () -> Ability.GOLDEN_HEAL, () -> Ability.RECOVERY, () -> Ability.MEAL_STEAL), null),
    AGILITY((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.LIGHT_FALL, () -> Ability.JUMPER, () -> Ability.SUGAR_RUSH, () -> Ability.FLEETING, () -> Ability.THUNDER_FALL), null),
    ALCHEMY((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.ALCHEMIST, () -> Ability.BREWER, () -> Ability.SPLASHER, () -> Ability.LINGERING, () -> Ability.WISE_EFFECT), null),
    ENCHANTING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.XP_CONVERT, () -> Ability.ENCHANTER, () -> Ability.XP_WARRIOR, () -> Ability.ENCHANTED_STRENGTH, () -> Ability.LUCKY_TABLE), null),
    SORCERY((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.SORCERER), null),
    HEALING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.LIFE_ESSENCE, () -> Ability.HEALER, () -> Ability.LIFE_STEAL, () -> Ability.GOLDEN_HEART, () -> Ability.REVIVAL), null),
    FORGING((ImmutableList<Supplier<Ability>>)ImmutableList.of(() -> Ability.DISENCHANTER, () -> Ability.FORGER, () -> Ability.REPAIRING, () -> Ability.ANVIL_MASTER, () -> Ability.SKILL_MENDER), null);

    private final ImmutableList<Supplier<Ability>> abilities;
    private final MAbility manaAbility;

    private Skills(ImmutableList<Supplier<Ability>> abilities, MAbility manaAbility) {
        this.abilities = abilities;
        this.manaAbility = manaAbility;
    }

    @Override
    public ImmutableList<Supplier<Ability>> getAbilities() {
        return this.abilities;
    }

    @Override
    public String getDescription(Locale locale) {
        return Lang.getMessage(SkillMessage.valueOf(this.name() + "_DESC"), locale);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return Lang.getMessage(SkillMessage.valueOf(this.name().toUpperCase() + "_NAME"), locale);
    }

    @Override
    @Nullable
    public MAbility getManaAbility() {
        return this.manaAbility;
    }

    public static List<Skills> getOrderedValues() {
        ArrayList<Skills> list = new ArrayList<Skills>();
        list.add(AGILITY);
        list.add(ALCHEMY);
        list.add(ARCHERY);
        list.add(DEFENSE);
        list.add(ENCHANTING);
        list.add(ENDURANCE);
        list.add(EXCAVATION);
        list.add(FARMING);
        list.add(FIGHTING);
        list.add(FISHING);
        list.add(FORAGING);
        list.add(FORGING);
        list.add(HEALING);
        list.add(MINING);
        list.add(SORCERY);
        return list;
    }
}

