/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards.parser;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.RewardMessage;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.rewards.builder.ItemRewardBuilder;
import com.archyx.aureliumskills.rewards.parser.RewardParser;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemRewardParser
extends RewardParser {
    public ItemRewardParser(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public Reward parse(Map<?, ?> map) {
        RewardMessage messageKey;
        ItemMeta meta;
        String key = this.getString(map, "key");
        ItemRewardBuilder builder = new ItemRewardBuilder(this.plugin).itemKey(key);
        int amount = 1;
        if (map.containsKey("amount")) {
            int definedAmount = this.getInt(map, "amount");
            builder.amount(definedAmount);
            amount = definedAmount;
        } else {
            ItemStack item = this.plugin.getItemRegistry().getItem(key);
            if (item != null) {
                amount = item.getAmount();
            }
        }
        if (map.containsKey("menu_message")) {
            builder.menuMessage(this.getString(map, "menu_message"));
        } else {
            ItemStack item = this.plugin.getItemRegistry().getItem(key);
            if (item != null && (meta = item.getItemMeta()) != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_MENU_MESSAGE : RewardMessage.ITEM_DEFAULT_MENU_MESSAGE_MULTIPLE;
                if (meta.hasDisplayName() || meta.hasLocalizedName()) {
                    builder.menuMessage(TextUtil.replace(Lang.getMessage(messageKey, Lang.getDefaultLanguage()), "{display_name}", meta.hasDisplayName() ? meta.getDisplayName() : meta.getLocalizedName(), "{amount}", String.valueOf(amount), "{key}", key));
                }
            }
        }
        if (map.containsKey("chat_message")) {
            builder.chatMessage(this.getString(map, "chat_message"));
        } else {
            ItemStack item = this.plugin.getItemRegistry().getItem(key);
            if (item != null && (meta = item.getItemMeta()) != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE : RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE_MULTIPLE;
                if (meta.hasDisplayName() || meta.hasLocalizedName()) {
                    builder.chatMessage(TextUtil.replace(Lang.getMessage(messageKey, Lang.getDefaultLanguage()), "{display_name}", meta.hasDisplayName() ? meta.getDisplayName() : meta.getLocalizedName(), "{amount}", String.valueOf(amount), "{key}", key));
                }
            }
        }
        if (map.containsKey("message")) {
            String message = this.getString(map, "message");
            builder.chatMessage(message).menuMessage(message);
        }
        return builder.build();
    }
}

