/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.LevelerMessage;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Locale;
import org.bukkit.entity.Player;

public class StatReward
extends Reward {
    private final Stat stat;
    private final double value;

    public StatReward(AureliumSkills plugin, Stat stat, double value) {
        super(plugin);
        this.stat = stat;
        this.value = value;
    }

    @Override
    public void giveReward(Player player, Skill skill, int level) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        playerData.addStatLevel(this.stat, this.value);
        new StatLeveler(this.plugin).reloadStat(player, this.stat);
    }

    public Stat getStat() {
        return this.stat;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String getMenuMessage(Player player, Locale locale, Skill skill, int level) {
        return TextUtil.replace(Lang.getMessage(MenuMessage.REWARDS_ENTRY, locale), "{color}", this.stat.getColor(locale), "{num}", NumberUtil.format1(this.value), "{symbol}", this.stat.getSymbol(locale), "{stat}", this.stat.getDisplayName(locale));
    }

    @Override
    public String getChatMessage(Player player, Locale locale, Skill skill, int level) {
        return TextUtil.replace(Lang.getMessage(LevelerMessage.STAT_LEVEL, locale), "{color}", this.stat.getColor(locale), "{num}", NumberUtil.format1(this.value), "{symbol}", this.stat.getSymbol(locale), "{stat}", this.stat.getDisplayName(locale));
    }
}

