/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.rewards.PermissionReward;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.rewards.StatReward;
import com.archyx.aureliumskills.stats.Stat;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class RewardTable {
    private final AureliumSkills plugin;
    private final List<Stat> statsLeveled;
    private final Map<Integer, List<Reward>> rewards;

    public RewardTable(AureliumSkills plugin) {
        this.plugin = plugin;
        this.rewards = new HashMap<Integer, List<Reward>>();
        this.statsLeveled = new ArrayList<Stat>();
    }

    public ImmutableList<Reward> getRewards(int level) {
        return ImmutableList.copyOf((Collection)this.rewards.getOrDefault(level, new ArrayList()));
    }

    public Map<Integer, List<Reward>> getRewardsMap() {
        return this.rewards;
    }

    public void addReward(Reward reward, int level) {
        StatReward statReward;
        List rewards = this.rewards.computeIfAbsent(level, k -> new ArrayList());
        rewards.add(reward);
        if (reward instanceof StatReward && !this.statsLeveled.contains((statReward = (StatReward)reward).getStat())) {
            this.statsLeveled.add(statReward.getStat());
        }
    }

    public ImmutableList<Stat> getStatsLeveled() {
        return ImmutableList.copyOf(this.statsLeveled);
    }

    public <T extends Reward> Map<Integer, ImmutableList<T>> searchRewards(Class<T> type) {
        HashMap<Integer, ImmutableList<T>> rewardMap = new HashMap<Integer, ImmutableList<T>>();
        for (Map.Entry<Integer, List<Reward>> entry : this.rewards.entrySet()) {
            ArrayList<T> rewardList = new ArrayList<T>();
            for (Reward reward : entry.getValue()) {
                if (!type.isInstance(reward)) continue;
                rewardList.add(type.cast(reward));
            }
            rewardMap.put(entry.getKey(), ImmutableList.copyOf(rewardList));
        }
        return rewardMap;
    }

    public <T extends Reward> ImmutableList<T> searchRewards(Class<T> type, int level) {
        ImmutableList<Reward> levelRewards = this.getRewards(level);
        ArrayList<T> rewardList = new ArrayList<T>();
        for (Reward reward : levelRewards) {
            if (!type.isInstance(reward)) continue;
            rewardList.add(type.cast(reward));
        }
        return ImmutableList.copyOf(rewardList);
    }

    public void applyStats(PlayerData playerData, int level) {
        Map<Integer, ImmutableList<StatReward>> statRewardMap = this.searchRewards(StatReward.class);
        for (int i = 2; i <= level; ++i) {
            ImmutableList<StatReward> statRewardList = statRewardMap.get(i);
            if (statRewardList == null) continue;
            for (StatReward statReward : statRewardList) {
                playerData.addStatLevel(statReward.getStat(), statReward.getValue());
            }
        }
    }

    public void applyPermissions(Player player, int level) {
        Map<Integer, ImmutableList<PermissionReward>> permissionRewardMap = this.searchRewards(PermissionReward.class);
        for (Map.Entry<Integer, ImmutableList<PermissionReward>> entry : permissionRewardMap.entrySet()) {
            int entryLevel = entry.getKey();
            for (PermissionReward reward : entry.getValue()) {
                if (!this.plugin.isLuckPermsEnabled()) continue;
                if (level >= entryLevel) {
                    this.plugin.getLuckPermsSupport().addPermission(player, reward.getPermission(), reward.getValue());
                    continue;
                }
                this.plugin.getLuckPermsSupport().removePermission(player, reward.getPermission(), reward.getValue());
            }
        }
    }
}

