/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.rewards.RewardTable;
import com.archyx.aureliumskills.rewards.RewardType;
import com.archyx.aureliumskills.rewards.parser.RewardParser;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.util.misc.DataUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RewardManager {
    private final AureliumSkills plugin;
    private final Map<Skill, RewardTable> rewardTables;

    public RewardManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.rewardTables = new HashMap<Skill, RewardTable>();
    }

    public RewardTable getRewardTable(Skill skill) {
        return this.rewardTables.get(skill);
    }

    public void loadRewards() {
        this.rewardTables.clear();
        File rewardsDirectory = new File(this.plugin.getDataFolder() + "/rewards");
        int patternsLoaded = 0;
        int levelsLoaded = 0;
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            File rewardsFile = new File(rewardsDirectory + "/" + skill.toString().toLowerCase(Locale.ROOT) + ".yml");
            if (!rewardsFile.exists()) {
                this.plugin.saveResource("rewards/" + skill.toString().toLowerCase(Locale.ROOT) + ".yml", false);
            }
            YamlConfiguration rewardsConfig = YamlConfiguration.loadConfiguration((File)rewardsFile);
            RewardTable rewardTable = new RewardTable(this.plugin);
            patternsLoaded += this.loadPatterns(rewardTable, (FileConfiguration)rewardsConfig, rewardsFile, OptionL.getMaxLevel(skill));
            levelsLoaded += this.loadLevels(rewardTable, (FileConfiguration)rewardsConfig, rewardsFile);
            this.rewardTables.put(skill, rewardTable);
        }
        File globalFile = new File(this.plugin.getDataFolder() + "/rewards/global.yml");
        if (!globalFile.exists()) {
            this.plugin.saveResource("rewards/global.yml", false);
        }
        YamlConfiguration globalConfig = YamlConfiguration.loadConfiguration((File)globalFile);
        RewardTable globalTable = new RewardTable(this.plugin);
        patternsLoaded += this.loadPatterns(globalTable, (FileConfiguration)globalConfig, globalFile, this.plugin.getOptionLoader().getHighestMaxLevel());
        levelsLoaded += this.loadLevels(globalTable, (FileConfiguration)globalConfig, globalFile);
        for (Map.Entry<Integer, List<Reward>> entry : globalTable.getRewardsMap().entrySet()) {
            int level = entry.getKey();
            List<Reward> rewards = entry.getValue();
            for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
                RewardTable rewardTable = this.rewardTables.get(skill);
                if (rewardTable == null) continue;
                for (Reward reward : rewards) {
                    rewardTable.addReward(reward, level);
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + patternsLoaded + " pattern rewards and " + levelsLoaded + " level rewards");
    }

    private int loadPatterns(RewardTable rewardTable, FileConfiguration rewardsConfig, File rewardsFile, int maxLevel) {
        int patternsLoaded = 0;
        List patterns = rewardsConfig.getMapList("patterns");
        for (int index = 0; index < patterns.size(); ++index) {
            Map rewardMap = (Map)patterns.get(index);
            try {
                Reward reward = this.parseReward(rewardMap);
                Object patternObj = DataUtil.getElement(rewardMap, "pattern");
                if (!(patternObj instanceof Map)) {
                    throw new IllegalArgumentException("Pattern must be a section");
                }
                Map patternMap = (Map)patternObj;
                int start = DataUtil.getInt(patternMap, "start");
                int interval = DataUtil.getInt(patternMap, "interval");
                int stop = maxLevel;
                if (patternMap.containsKey("stop")) {
                    stop = DataUtil.getInt(patternMap, "stop");
                }
                if (stop > maxLevel) {
                    stop = maxLevel;
                }
                for (int level = start; level <= stop; level += interval) {
                    rewardTable.addReward(reward, level);
                }
                ++patternsLoaded;
                continue;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Error while loading rewards file " + rewardsFile.getName() + " at path patterns.[" + index + "]: " + e.getMessage());
            }
        }
        return patternsLoaded;
    }

    private int loadLevels(RewardTable rewardTable, FileConfiguration rewardsConfig, File rewardsFile) {
        int levelsLoaded = 0;
        ConfigurationSection levelsSection = rewardsConfig.getConfigurationSection("levels");
        if (levelsSection != null) {
            for (String levelString : levelsSection.getKeys(false)) {
                try {
                    int level = Integer.parseInt(levelString);
                    List rewards = levelsSection.getMapList(levelString);
                    for (int index = 0; index < rewards.size(); ++index) {
                        Map rewardMap = (Map)rewards.get(index);
                        try {
                            Reward reward = this.parseReward(rewardMap);
                            rewardTable.addReward(reward, level);
                            ++levelsLoaded;
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + levelString + ".[" + index + "]: " + e.getMessage());
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + levelString + ": Key " + levelString + " must be of type int");
                }
            }
        }
        return levelsLoaded;
    }

    private Reward parseReward(Map<?, ?> map) {
        String type = DataUtil.getString(map, "type");
        for (RewardType rewardType : RewardType.values()) {
            if (!rewardType.getKey().equalsIgnoreCase(type)) continue;
            try {
                Constructor<? extends RewardParser> constructor = rewardType.getParser().getConstructor(AureliumSkills.class);
                return constructor.newInstance(new Object[]{this.plugin}).parse(map);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("Unrecognized reward type: " + type);
    }

    public List<Skill> getSkillsLeveledBy(Stat stat) {
        ArrayList<Skill> skillsLeveledBy = new ArrayList<Skill>();
        block0: for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            RewardTable table;
            if (!OptionL.isEnabled(skill) || (table = this.rewardTables.get(skill)) == null) continue;
            for (Stat statLeveled : table.getStatsLeveled()) {
                if (!statLeveled.equals(stat)) continue;
                skillsLeveledBy.add(skill);
                continue block0;
            }
        }
        return skillsLeveledBy;
    }
}

