/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.CustomMessageKey;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Locale;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public abstract class MessagedReward
extends Reward {
    protected final String menuMessage;
    protected final String chatMessage;

    public MessagedReward(AureliumSkills plugin, String menuMessage, String chatMessage) {
        super(plugin);
        this.menuMessage = menuMessage;
        this.chatMessage = chatMessage;
    }

    @Override
    public String getMenuMessage(Player player, Locale locale, Skill skill, int level) {
        return this.attemptAsMessageKey(this.menuMessage, player, locale, skill, level);
    }

    @Override
    public String getChatMessage(Player player, Locale locale, Skill skill, int level) {
        return this.attemptAsMessageKey(this.chatMessage, player, locale, skill, level);
    }

    private String attemptAsMessageKey(String potentialKey, Player player, Locale locale, Skill skill, int level) {
        CustomMessageKey key = new CustomMessageKey(potentialKey);
        String message = Lang.getMessage(key, locale);
        if (message == null) {
            message = potentialKey;
        }
        return this.replacePlaceholders(message, player, skill, level);
    }

    private String replacePlaceholders(String message, Player player, Skill skill, int level) {
        message = TextUtil.replace(message, "{player}", player.getName(), "{skill}", skill.toString().toLowerCase(Locale.ROOT), "{level}", String.valueOf(level));
        if (this.plugin.isPlaceholderAPIEnabled()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        message = TextUtil.replaceNonEscaped(message, "&", "\u00a7");
        return message;
    }
}

