/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.LevelerMessage;
import com.archyx.aureliumskills.rewards.MessagedReward;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemReward
extends MessagedReward {
    private final String itemKey;
    private final int amount;

    public ItemReward(AureliumSkills plugin, String menuMessage, String chatMessage, String itemKey, int amount) {
        super(plugin, menuMessage, chatMessage);
        this.itemKey = itemKey;
        this.amount = amount;
    }

    @Override
    public void giveReward(Player player, Skill skill, int level) {
        ItemStack leftoverItem;
        ItemStack item = this.plugin.getItemRegistry().getItem(this.itemKey);
        if (item == null) {
            this.plugin.getLogger().warning("Could not find a registered item with key " + this.itemKey + " when granting item reward (" + StringUtils.capitalize((String)skill.toString().toLowerCase(Locale.ROOT)) + " " + level + ")");
            return;
        }
        if (this.amount != -1) {
            item.setAmount(this.amount);
        }
        if ((leftoverItem = ItemUtils.addItemToInventory(player, item)) != null) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            playerData.getUnclaimedItems().add(new KeyIntPair(this.itemKey, leftoverItem.getAmount()));
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> player.sendMessage(AureliumSkills.getPrefix(playerData.getLocale()) + Lang.getMessage(LevelerMessage.UNCLAIMED_ITEM, playerData.getLocale())), 1L);
        }
    }
}

