/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.rewards;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.commands.CommandExecutor;
import com.archyx.aureliumskills.rewards.MessagedReward;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Locale;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandReward
extends MessagedReward {
    private final CommandExecutor executor;
    private final String command;
    private final CommandExecutor revertExecutor;
    private final String revertCommand;

    public CommandReward(AureliumSkills plugin, String menuMessage, String chatMessage, CommandExecutor executor, String command, CommandExecutor revertExecutor, String revertCommand) {
        super(plugin, menuMessage, chatMessage);
        this.executor = executor;
        this.command = command;
        this.revertExecutor = revertExecutor;
        this.revertCommand = revertCommand;
    }

    @Override
    public void giveReward(Player player, Skill skill, int level) {
        this.executeCommand(this.executor, this.command, player, skill, level);
    }

    public void executeRevert(Player player, Skill skill, int level) {
        if (this.revertCommand != null) {
            this.executeCommand(this.revertExecutor != null ? this.revertExecutor : CommandExecutor.CONSOLE, this.command, player, skill, level);
        }
    }

    private void executeCommand(CommandExecutor executor, String command, Player player, Skill skill, int level) {
        String executedCommand = TextUtil.replace(command, "{player}", player.getName(), "{skill}", skill.toString().toLowerCase(Locale.ROOT), "{level}", String.valueOf(level));
        if (this.plugin.isPlaceholderAPIEnabled()) {
            executedCommand = PlaceholderAPI.setPlaceholders((Player)player, (String)executedCommand);
        }
        executedCommand = TextUtil.replaceNonEscaped(executedCommand, "&", "\u00a7");
        if (executor == CommandExecutor.CONSOLE) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), executedCommand);
        } else {
            player.performCommand(executedCommand);
        }
    }
}

