/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.requirement;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTItem;
import com.archyx.aureliumskills.requirement.GlobalRequirement;
import com.archyx.aureliumskills.requirement.RequirementManager;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class Requirements {
    private final AureliumSkills plugin;
    private final RequirementManager manager;

    public Requirements(AureliumSkills plugin) {
        this.plugin = plugin;
        this.manager = plugin.getRequirementManager();
    }

    public Map<Skill, Integer> getRequirements(ModifierType type, ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        HashMap<Skill, Integer> requirements = new HashMap<Skill, Integer>();
        NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            try {
                Skill skill = this.plugin.getSkillRegistry().getSkill(key);
                if (skill == null) continue;
                Integer value = compound.getInteger(key);
                requirements.put(skill, value);
            }
            catch (Exception exception) {}
        }
        return requirements;
    }

    public Map<Skill, Integer> getGlobalRequirements(ModifierType type, ItemStack item) {
        HashMap<Skill, Integer> requirements = new HashMap<Skill, Integer>();
        for (GlobalRequirement global : this.manager.getGlobalRequirementsType(type)) {
            if (XMaterial.isNewVersion()) {
                if (global.getMaterial().parseMaterial() != item.getType()) continue;
                requirements.putAll(global.getRequirements());
                continue;
            }
            if (global.getMaterial().parseMaterial() == item.getType()) {
                MaterialData materialData;
                if (ItemUtils.isDurable(item.getType()) || (materialData = item.getData()) == null || item.getDurability() != global.getMaterial().getData()) continue;
                requirements.putAll(global.getRequirements());
                continue;
            }
            requirements.putAll(global.getRequirements());
        }
        return requirements;
    }

    public ItemStack addRequirement(ModifierType type, ItemStack item, Skill skill, int level) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
        compound.setInteger(this.getName(skill), level);
        return nbtItem.getItem();
    }

    public ItemStack removeRequirement(ModifierType type, ItemStack item, Skill skill) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            if (!key.equals(this.getName(skill))) continue;
            compound.removeKey(key);
        }
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public ItemStack removeAllRequirements(ModifierType type, ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
        compound.getKeys().forEach(compound::removeKey);
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public boolean hasRequirement(ModifierType type, ItemStack item, Skill skill) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            if (!key.equals(this.getName(skill))) continue;
            return true;
        }
        return false;
    }

    public ItemStack convertFromLegacy(ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound oldRequirementsCompound = nbtItem.getCompound("skillRequirements");
        if (oldRequirementsCompound != null) {
            for (ModifierType type : ModifierType.values()) {
                NBTCompound oldTypeCompound = oldRequirementsCompound.getCompound(type.toString().toLowerCase(Locale.ENGLISH));
                if (oldTypeCompound == null) continue;
                NBTCompound compound = ItemUtils.getRequirementsTypeCompound(nbtItem, type);
                for (String key : oldTypeCompound.getKeys()) {
                    compound.setInteger(StringUtils.capitalize((String)key), oldTypeCompound.getInteger(key));
                }
            }
        }
        nbtItem.removeKey("skillRequirements");
        return nbtItem.getItem();
    }

    public void addLore(ModifierType type, ItemStack item, Skill skill, int level, Locale locale) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String text = TextUtil.replace(Lang.getMessage(CommandMessage.valueOf(type.name() + "_REQUIREMENT_ADD_LORE"), locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level));
            ArrayList<String> lore = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
            if (lore != null) {
                lore.add(text);
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
    }

    public void removeLore(ItemStack item, Skill skill) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore = meta.getLore();
            if (lore != null) {
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    if (!line.contains("Requires") || !line.contains(StringUtils.capitalize((String)skill.name().toLowerCase(Locale.ENGLISH)))) continue;
                    lore.remove(line);
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
    }

    public boolean meetsRequirements(ModifierType type, ItemStack item, Player player) {
        if (!OptionL.getBoolean(Option.REQUIREMENT_ENABLED)) {
            return true;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return true;
        }
        for (Map.Entry<Skill, Integer> entry : this.getGlobalRequirements(type, item).entrySet()) {
            if (playerData.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        for (Map.Entry<Skill, Integer> entry : this.getRequirements(type, item).entrySet()) {
            if (playerData.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private String getName(Skill skill) {
        return StringUtils.capitalize((String)skill.name().toLowerCase(Locale.ENGLISH));
    }
}

