/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.requirement;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.requirement.GlobalRequirement;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RequirementManager
implements Listener {
    private Set<GlobalRequirement> globalRequirements;
    private final Map<UUID, Integer> errorMessageTimer = new HashMap<UUID, Integer>();
    private final AureliumSkills plugin;

    public RequirementManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.tickTimer();
    }

    public void load() {
        FileConfiguration config = this.plugin.getConfig();
        this.globalRequirements = new HashSet<GlobalRequirement>();
        for (ModifierType type : ModifierType.values()) {
            List list = config.getStringList("requirement." + type.name().toLowerCase(Locale.ENGLISH) + ".global");
            for (String text : list) {
                String[] splitText = text.split(" ");
                Optional<XMaterial> potentialMaterial = XMaterial.matchXMaterial(splitText[0].toUpperCase());
                if (potentialMaterial.isPresent()) {
                    XMaterial material = potentialMaterial.get();
                    HashMap<Skill, Integer> requirements = new HashMap<Skill, Integer>();
                    for (int i = 1; i < splitText.length; ++i) {
                        String requirementText = splitText[i];
                        try {
                            Skill skill = this.plugin.getSkillRegistry().getSkill(requirementText.split(":")[0]);
                            if (skill == null) continue;
                            int level = Integer.parseInt(requirementText.split(":")[1]);
                            requirements.put(skill, level);
                            continue;
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().warning("[AureliumSkills] Error parsing global skill " + type.name().toLowerCase(Locale.ENGLISH) + " requirement skill level pair with text " + requirementText);
                        }
                    }
                    GlobalRequirement globalRequirement = new GlobalRequirement(type, material, requirements);
                    this.globalRequirements.add(globalRequirement);
                    continue;
                }
                Bukkit.getLogger().warning("[AureliumSkills] Error parsing global skill " + type.name().toLowerCase(Locale.ENGLISH) + " requirement material with text " + splitText[0]);
            }
        }
    }

    public Set<GlobalRequirement> getGlobalRequirements() {
        return this.globalRequirements;
    }

    public Set<GlobalRequirement> getGlobalRequirementsType(ModifierType type) {
        HashSet<GlobalRequirement> matched = new HashSet<GlobalRequirement>();
        for (GlobalRequirement requirement : this.globalRequirements) {
            if (requirement.getType() != type) continue;
            matched.add(requirement);
        }
        return matched;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.errorMessageTimer.remove(event.getPlayer().getUniqueId());
    }

    public void tickTimer() {
        new BukkitRunnable(){

            public void run() {
                for (UUID id : RequirementManager.this.errorMessageTimer.keySet()) {
                    int timer = (Integer)RequirementManager.this.errorMessageTimer.get(id);
                    if (timer == 0) continue;
                    RequirementManager.this.errorMessageTimer.put(id, (Integer)RequirementManager.this.errorMessageTimer.get(id) - 1);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 5L);
    }

    public Map<UUID, Integer> getErrorMessageTimer() {
        return this.errorMessageTimer;
    }
}

