/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.region;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTCompoundList;
import com.archyx.aureliumskills.nbtapi.NBTContainer;
import com.archyx.aureliumskills.nbtapi.NBTFile;
import com.archyx.aureliumskills.nbtapi.NBTListCompound;
import com.archyx.aureliumskills.nbtapi.NbtApiException;
import com.archyx.aureliumskills.region.BlockPosition;
import com.archyx.aureliumskills.region.ChunkCoordinate;
import com.archyx.aureliumskills.region.ChunkData;
import com.archyx.aureliumskills.region.Region;
import com.archyx.aureliumskills.region.RegionCoordinate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class RegionManager {
    private final AureliumSkills plugin;
    private final ConcurrentMap<RegionCoordinate, Region> regions;
    private boolean saving;

    public RegionManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.regions = new ConcurrentHashMap<RegionCoordinate, Region>();
        this.saving = false;
    }

    @Nullable
    public Region getRegion(RegionCoordinate regionCoordinate) {
        return (Region)this.regions.get(regionCoordinate);
    }

    public boolean isPlacedBlock(Block block) {
        byte regionChunkZ;
        byte regionChunkX;
        ChunkData chunkData;
        int chunkX = block.getChunk().getX();
        int chunkZ = block.getChunk().getZ();
        int regionX = (int)Math.floor((double)chunkX / 32.0);
        int regionZ = (int)Math.floor((double)chunkZ / 32.0);
        Region region = (Region)this.regions.get(new RegionCoordinate(block.getWorld(), regionX, regionZ));
        if (region != null && (chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX = (byte)(chunkX - regionX * 32), regionChunkZ = (byte)(chunkZ - regionZ * 32)))) != null) {
            BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
            return chunkData.isPlacedBlock(blockPosition);
        }
        return false;
    }

    public void addPlacedBlock(Block block) {
        int chunkX = block.getChunk().getX();
        int chunkZ = block.getChunk().getZ();
        int regionX = (int)Math.floor((double)chunkX / 32.0);
        int regionZ = (int)Math.floor((double)chunkZ / 32.0);
        RegionCoordinate regionCoordinate = new RegionCoordinate(block.getWorld(), regionX, regionZ);
        Region region = (Region)this.regions.get(regionCoordinate);
        if (region == null) {
            region = new Region(block.getWorld(), regionX, regionZ);
            this.regions.put(regionCoordinate, region);
            this.loadRegion(region);
        } else if (region.shouldReload()) {
            this.loadRegion(region);
        }
        byte regionChunkX = (byte)(chunkX - regionX * 32);
        byte regionChunkZ = (byte)(chunkZ - regionZ * 32);
        ChunkData chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX, regionChunkZ));
        if (chunkData == null) {
            chunkData = new ChunkData(region, regionChunkX, regionChunkZ);
            region.setChunkData(new ChunkCoordinate(regionChunkX, regionChunkZ), chunkData);
        }
        chunkData.addPlacedBlock(new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    public void removePlacedBlock(Block block) {
        byte regionChunkZ;
        byte regionChunkX;
        ChunkData chunkData;
        int chunkX = block.getChunk().getX();
        int chunkZ = block.getChunk().getZ();
        int regionX = (int)Math.floor((double)chunkX / 32.0);
        int regionZ = (int)Math.floor((double)chunkZ / 32.0);
        RegionCoordinate regionCoordinate = new RegionCoordinate(block.getWorld(), regionX, regionZ);
        Region region = (Region)this.regions.get(regionCoordinate);
        if (region != null && (chunkData = region.getChunkData(new ChunkCoordinate(regionChunkX = (byte)(chunkX - regionX * 32), regionChunkZ = (byte)(chunkZ - regionZ * 32)))) != null) {
            chunkData.removePlacedBlock(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        }
    }

    public void loadRegion(Region region) {
        if (region.isLoading()) {
            return;
        }
        region.setLoading(true);
        RegionCoordinate regionCoordinate = new RegionCoordinate(region.getWorld(), region.getX(), region.getZ());
        World world = regionCoordinate.getWorld();
        int regionX = regionCoordinate.getX();
        int regionZ = regionCoordinate.getZ();
        File file = new File(this.plugin.getDataFolder() + "/regiondata/" + world.getName() + "/r." + regionX + "." + regionZ + ".asrg");
        if (file.exists()) {
            if (this.saving) {
                region.setReload(true);
            }
            try {
                NBTFile nbtFile = new NBTFile(file);
                for (String key : nbtFile.getKeys()) {
                    if (!key.startsWith("chunk")) continue;
                    int commaIndex = key.indexOf(",");
                    byte chunkX = Byte.parseByte(key.substring(key.indexOf("[") + 1, commaIndex));
                    byte chunkZ = Byte.parseByte(key.substring(commaIndex + 1, key.lastIndexOf("]")));
                    NBTCompound chunkCompound = nbtFile.getCompound(key);
                    ChunkCoordinate chunkCoordinate = new ChunkCoordinate(chunkX, chunkZ);
                    this.loadChunk(region, chunkCoordinate, chunkCompound);
                }
                region.setReload(false);
            }
            catch (NbtApiException e) {
                boolean deleted = file.delete();
                if (deleted) {
                    this.plugin.getLogger().warning("Deleted " + file.getName() + " because it was corrupted, this won't affect anything");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        region.setLoading(false);
    }

    private void loadChunk(Region region, ChunkCoordinate chunkCoordinate, NBTCompound compound) {
        ChunkData chunkData = region.getChunkData(chunkCoordinate);
        if (chunkData == null) {
            chunkData = new ChunkData(region, chunkCoordinate.getX(), chunkCoordinate.getZ());
        }
        NBTCompoundList placedBlocks = compound.getCompoundList("placed_blocks");
        for (NBTListCompound block : placedBlocks) {
            int x = block.getInteger("x");
            int y = block.getInteger("y");
            int z = block.getInteger("z");
            chunkData.addPlacedBlock(new BlockPosition(x, y, z));
        }
        region.setChunkData(chunkCoordinate, chunkData);
    }

    private void saveRegion(World world, int regionX, int regionZ) throws IOException {
        block10: {
            RegionCoordinate regionCoordinate = new RegionCoordinate(world, regionX, regionZ);
            Region region = this.getRegion(regionCoordinate);
            if (region == null) {
                return;
            }
            if (region.getChunkMap().size() == 0) {
                return;
            }
            File file = new File(this.plugin.getDataFolder() + "/regiondata/" + world.getName() + "/r." + regionX + "." + regionZ + ".asrg");
            try {
                NBTFile nbtFile = new NBTFile(file);
                for (ChunkData chunkData : region.getChunkMap().values()) {
                    this.saveChunk(nbtFile, chunkData);
                }
                if (nbtFile.getKeys().size() == 0) {
                    if (file.exists()) {
                        try {
                            Files.delete(file.toPath());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    nbtFile.save();
                }
            }
            catch (NbtApiException e) {
                boolean deleted = file.delete();
                if (!deleted) break block10;
                this.plugin.getLogger().warning("Deleted " + file.getName() + " because it was corrupted, this won't affect anything");
            }
        }
    }

    private void saveChunk(NBTFile nbtFile, ChunkData chunkData) {
        NBTCompound chunk = nbtFile.getOrCreateCompound("chunk[" + chunkData.getX() + "," + chunkData.getZ() + "]");
        NBTCompoundList placedBlocks = chunk.getCompoundList("placed_blocks");
        placedBlocks.clear();
        for (BlockPosition block : chunkData.getPlacedBlocks().keySet()) {
            NBTContainer compound = new NBTContainer();
            compound.setInteger("x", block.getX());
            compound.setInteger("y", block.getY());
            compound.setInteger("z", block.getZ());
            placedBlocks.addCompound(compound);
        }
        if (placedBlocks.size() == 0) {
            chunk.removeKey("placed_blocks");
        }
        if (chunk.getKeys().size() == 0) {
            nbtFile.removeKey(chunk.getName());
        }
    }

    public void saveAllRegions(boolean clearUnused, boolean serverShutdown) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        for (Region region : this.regions.values()) {
            try {
                this.saveRegion(region.getWorld(), region.getX(), region.getZ());
                if (!clearUnused || !this.isRegionUnused(region)) continue;
                this.regions.remove(new RegionCoordinate(region.getWorld(), region.getX(), region.getZ()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!serverShutdown) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.saving = false;
            }, 20L);
        } else {
            this.saving = false;
        }
    }

    private boolean isRegionUnused(Region region) {
        for (int chunkX = region.getX() * 32; chunkX < region.getX() * 32 + 32; ++chunkX) {
            for (int chunkZ = region.getZ() * 32; chunkZ < region.getZ() * 32 + 32; ++chunkZ) {
                if (!region.getWorld().isChunkLoaded(chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }

    public void clearRegionMap() {
        this.regions.clear();
    }

    public void setRegion(RegionCoordinate coordinate, Region region) {
        this.regions.put(coordinate, region);
    }
}

