/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.region;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.region.Region;
import com.archyx.aureliumskills.region.RegionCoordinate;
import com.archyx.aureliumskills.region.RegionManager;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RegionListener
implements Listener {
    private final AureliumSkills plugin;
    private final RegionManager regionManager;

    public RegionListener(AureliumSkills plugin) {
        this.plugin = plugin;
        this.regionManager = plugin.getRegionManager();
        this.startSaveTimer();
    }

    @EventHandler
    public void onChunkLoad(final ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        final int regionX = (int)Math.floor((double)chunk.getX() / 32.0);
        final int regionZ = (int)Math.floor((double)chunk.getZ() / 32.0);
        final RegionCoordinate regionCoordinate = new RegionCoordinate(event.getWorld(), regionX, regionZ);
        Region region = this.regionManager.getRegion(regionCoordinate);
        if (region == null || region.shouldReload()) {
            new BukkitRunnable(){

                public void run() {
                    Region obtainedRegion = RegionListener.this.regionManager.getRegion(regionCoordinate);
                    if (obtainedRegion == null) {
                        obtainedRegion = new Region(event.getWorld(), regionX, regionZ);
                        RegionListener.this.regionManager.setRegion(regionCoordinate, obtainedRegion);
                        RegionListener.this.regionManager.loadRegion(obtainedRegion);
                    } else if (obtainedRegion.shouldReload()) {
                        RegionListener.this.regionManager.loadRegion(obtainedRegion);
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    public void startSaveTimer() {
        new BukkitRunnable(){

            public void run() {
                RegionListener.this.regionManager.saveAllRegions(true, false);
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
    }
}

