/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.region;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.region.RegionManager;
import com.archyx.aureliumskills.skills.excavation.ExcavationSource;
import com.archyx.aureliumskills.skills.farming.FarmingSource;
import com.archyx.aureliumskills.skills.foraging.ForagingSource;
import com.archyx.aureliumskills.skills.mining.MiningSource;
import com.archyx.aureliumskills.source.SourceManager;
import com.archyx.aureliumskills.util.block.BlockFaceUtil;
import com.archyx.aureliumskills.xseries.XBlock;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RegionBlockListener
implements Listener {
    private Material[] customMaterials;
    private final AureliumSkills plugin;
    private final RegionManager regionManager;

    public RegionBlockListener(AureliumSkills plugin) {
        this.plugin = plugin;
        this.regionManager = plugin.getRegionManager();
        SourceManager sourceManager = plugin.getSourceManager();
        this.customMaterials = new Material[sourceManager.getCustomBlockSet().size()];
        int pos = 0;
        for (XMaterial material : sourceManager.getCustomBlockSet()) {
            this.customMaterials[pos] = material.parseMaterial();
            ++pos;
        }
    }

    public void reloadCustomBlocks() {
        SourceManager sourceManager = this.plugin.getSourceManager();
        this.customMaterials = new Material[sourceManager.getCustomBlockSet().size()];
        int pos = 0;
        for (XMaterial material : sourceManager.getCustomBlockSet()) {
            this.customMaterials[pos] = material.parseMaterial();
            ++pos;
        }
    }

    @EventHandler
    public void checkPlace(BlockPlaceEvent event) {
        FarmingSource farmingSource;
        if (this.plugin.getWorldManager().isInBlockedCheckWorld(event.getBlock().getLocation())) {
            return;
        }
        if (this.plugin.isWorldGuardEnabled() && this.plugin.getWorldGuardSupport().isInBlockedCheckRegion(event.getBlock().getLocation())) {
            return;
        }
        if (!OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE)) {
            return;
        }
        Material material = event.getBlock().getType();
        Block block = event.getBlock();
        if (MiningSource.getSource(block) != null || ForagingSource.getSource(block) != null || ExcavationSource.getSource(block) != null) {
            this.regionManager.addPlacedBlock(block);
        }
        if ((farmingSource = FarmingSource.getSource(block)) != null && farmingSource.shouldCheckBlockReplace()) {
            this.regionManager.addPlacedBlock(block);
            if (block.getRelative(BlockFace.DOWN).getType() == XMaterial.BAMBOO_SAPLING.parseMaterial()) {
                this.regionManager.addPlacedBlock(block.getRelative(BlockFace.DOWN));
            }
        }
        if (block.getType() == XMaterial.BAMBOO_SAPLING.parseMaterial()) {
            this.regionManager.addPlacedBlock(block);
        }
        for (Material checkedMaterial : this.customMaterials) {
            if (!material.equals((Object)checkedMaterial)) continue;
            this.regionManager.addPlacedBlock(event.getBlock());
            break;
        }
    }

    @EventHandler
    public void onSandFall(EntityChangeBlockEvent event) {
        Block below;
        Block block = event.getBlock();
        if (!this.regionManager.isPlacedBlock(block)) {
            return;
        }
        final Material type = block.getType();
        if ((type == Material.SAND || type.toString().equals("RED_SAND") || type == Material.GRAVEL) && ((below = block.getRelative(BlockFace.DOWN)).getType() == Material.AIR || below.getType().toString().equals("CAVE_AIR") || below.getType().toString().equals("VOID_AIR") || below.getType() == Material.WATER || below.getType().toString().equals("BUBBLE_COLUMN") || below.getType() == Material.LAVA)) {
            this.regionManager.removePlacedBlock(block);
            final Entity entity = event.getEntity();
            final AtomicInteger counter = new AtomicInteger();
            new BukkitRunnable(){

                public void run() {
                    Block currentBlock = entity.getLocation().getBlock();
                    if (entity.isDead() || !entity.isValid()) {
                        if (currentBlock.getType() == type) {
                            RegionBlockListener.this.regionManager.addPlacedBlock(entity.getLocation().getBlock());
                        }
                        this.cancel();
                    } else if (currentBlock.getType().toString().contains("WEB")) {
                        this.cancel();
                    } else if (counter.incrementAndGet() >= 200) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void checkBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        this.regionManager.removePlacedBlock(block);
        this.checkTallPlant(block, 0, XBlock::isSugarCane);
        this.checkTallPlant(block, 0, mat -> mat == XMaterial.BAMBOO.parseMaterial());
        this.checkTallPlant(block, 0, mat -> mat == Material.CACTUS);
        this.checkBlocksRequiringSupportBelow(block);
        this.checkAmethystCluster(block);
    }

    @EventHandler
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
        }
        this.regionManager.removePlacedBlock(event.getBlock().getRelative(event.getDirection()));
    }

    @EventHandler
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block lastBlock = event.getBlock();
        for (Block block : event.getBlocks()) {
            if (!this.regionManager.isPlacedBlock(block)) continue;
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
            if (!(block.getLocation().distanceSquared(event.getBlock().getLocation()) > lastBlock.getLocation().distanceSquared(event.getBlock().getLocation()))) continue;
            lastBlock = block;
        }
        this.regionManager.removePlacedBlock(lastBlock);
    }

    private void checkTallPlant(Block block, int num, Predicate<Material> isMaterial) {
        Block above;
        if (num < 20 && isMaterial.test((above = block.getRelative(BlockFace.UP)).getType()) && this.regionManager.isPlacedBlock(above)) {
            this.regionManager.removePlacedBlock(above);
            this.checkTallPlant(above, num + 1, isMaterial);
        }
    }

    private void checkBlocksRequiringSupportBelow(final Block block) {
        final Block above = block.getRelative(BlockFace.UP);
        final ForagingSource source = ForagingSource.getSource(above);
        if (source != null && source.requiresBlockBelow() && this.regionManager.isPlacedBlock(above)) {
            new BukkitRunnable(){

                public void run() {
                    if (!source.isMatch(block)) {
                        RegionBlockListener.this.regionManager.removePlacedBlock(above);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private void checkAmethystCluster(final Block block) {
        for (BlockFace face : BlockFaceUtil.getBlockSides()) {
            Block checkedBlock = block.getRelative(face);
            if (!MiningSource.AMETHYST_CLUSTER.isMatch(block) || !this.regionManager.isPlacedBlock(checkedBlock)) continue;
            new BukkitRunnable(){

                public void run() {
                    if (!MiningSource.AMETHYST_CLUSTER.isMatch(block)) {
                        RegionBlockListener.this.regionManager.removePlacedBlock(block);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }
}

