/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.region;

import com.archyx.aureliumskills.region.ChunkCoordinate;
import com.archyx.aureliumskills.region.ChunkData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class Region {
    private final World world;
    private final int x;
    private final int z;
    private final ConcurrentMap<ChunkCoordinate, ChunkData> chunks;
    private boolean reload;
    private boolean loading;

    public Region(World world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.chunks = new ConcurrentHashMap<ChunkCoordinate, ChunkData>();
        this.reload = false;
        this.loading = false;
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    @Nullable
    public ChunkData getChunkData(ChunkCoordinate chunkCoordinate) {
        return (ChunkData)this.chunks.get(chunkCoordinate);
    }

    public void setChunkData(ChunkCoordinate chunkCoordinate, ChunkData chunkData) {
        this.chunks.put(chunkCoordinate, chunkData);
    }

    public Map<ChunkCoordinate, ChunkData> getChunkMap() {
        return this.chunks;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public boolean shouldReload() {
        return this.reload;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }
}

