/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.region;

import com.archyx.aureliumskills.region.BlockPosition;
import com.archyx.aureliumskills.region.Region;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ChunkData {
    private final Region region;
    private final byte x;
    private final byte z;
    private final ConcurrentMap<BlockPosition, BlockPosition> placedBlocks;

    public ChunkData(Region region, byte x, byte z) {
        this.region = region;
        this.x = x;
        this.z = z;
        this.placedBlocks = new ConcurrentHashMap<BlockPosition, BlockPosition>();
    }

    public Region getRegion() {
        return this.region;
    }

    public byte getX() {
        return this.x;
    }

    public byte getZ() {
        return this.z;
    }

    public boolean isPlacedBlock(BlockPosition blockPosition) {
        return this.placedBlocks.containsKey(blockPosition);
    }

    public ConcurrentMap<BlockPosition, BlockPosition> getPlacedBlocks() {
        return this.placedBlocks;
    }

    public void addPlacedBlock(BlockPosition blockPosition) {
        this.placedBlocks.put(blockPosition, blockPosition);
    }

    public void removePlacedBlock(BlockPosition blockPosition) {
        this.placedBlocks.remove(blockPosition);
    }
}

