/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.nbtapi;

import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTContainer;
import com.archyx.aureliumskills.nbtapi.NBTReflectionUtil;
import com.archyx.aureliumskills.nbtapi.utils.MinecraftVersion;
import com.archyx.aureliumskills.nbtapi.utils.annotations.AvailableSince;
import com.archyx.aureliumskills.nbtapi.utils.annotations.CheckUtil;
import com.archyx.aureliumskills.nbtapi.utils.annotations.FAUtil;
import org.bukkit.block.BlockState;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_8_R3) && !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("PublicBukkitValues").booleanValue()) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

