/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.nbtapi;

import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTPersistentDataContainer;
import com.archyx.aureliumskills.nbtapi.NBTReflectionUtil;
import com.archyx.aureliumskills.nbtapi.utils.MinecraftVersion;
import com.archyx.aureliumskills.nbtapi.utils.annotations.AvailableSince;
import com.archyx.aureliumskills.nbtapi.utils.annotations.CheckUtil;
import com.archyx.aureliumskills.nbtapi.utils.annotations.FAUtil;
import org.bukkit.entity.Entity;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        return new NBTPersistentDataContainer(this.ent.getPersistentDataContainer());
    }
}

