/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.modifier;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTItem;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class Multipliers {
    private final AureliumSkills plugin;

    public Multipliers(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public List<Multiplier> getMultipliers(ModifierType type, ItemStack item) {
        if (!OptionL.getBoolean(Option.MODIFIER_MULTIPLIER_ENABLED)) {
            return new ArrayList<Multiplier>();
        }
        NBTItem nbtItem = new NBTItem(item);
        ArrayList<Multiplier> multipliers = new ArrayList<Multiplier>();
        NBTCompound compound = ItemUtils.getMultipliersTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            double value = compound.getDouble(key);
            Skill skill = this.plugin.getSkillRegistry().getSkill(key);
            String skillName = this.getNBTName(skill);
            if (type == ModifierType.ITEM) {
                multipliers.add(new Multiplier("AureliumSkills.Multipliers.Item." + skillName, skill, value));
                continue;
            }
            if (type != ModifierType.ARMOR) continue;
            String slot = "Helmet";
            String mat = item.getType().toString();
            if (mat.contains("CHESTPLATE")) {
                slot = "Chestplate";
            } else if (mat.contains("LEGGINGS")) {
                slot = "Leggings";
            } else if (mat.contains("BOOTS")) {
                slot = "Boots";
            }
            multipliers.add(new Multiplier("AureliumSkills.Multipliers.Armor." + slot + "." + skillName, skill, value));
        }
        return multipliers;
    }

    public ItemStack addMultiplier(ModifierType type, ItemStack item, @Nullable Skill skill, double value) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getMultipliersTypeCompound(nbtItem, type);
        compound.setDouble(this.getNBTName(skill), value);
        return nbtItem.getItem();
    }

    public ItemStack removeMultiplier(ModifierType type, ItemStack item, @Nullable Skill skill) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getMultipliersTypeCompound(nbtItem, type);
        compound.removeKey(this.getNBTName(skill));
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public ItemStack removeAllMultipliers(ModifierType type, ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getMultipliersTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            compound.removeKey(key);
        }
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public void addLore(ModifierType type, ItemStack item, Skill skill, double value, Locale locale) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore = meta.getLore() != null ? (meta.getLore().size() > 0 ? meta.getLore() : new LinkedList()) : new LinkedList();
            if (skill != null) {
                CommandMessage message = value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_SKILL_LORE") : CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_SKILL_LORE_SUBTRACT");
                if (lore.size() > 0) {
                    lore.add(" ");
                }
                lore.add(TextUtil.replace(Lang.getMessage(message, locale), "{skill}", skill.getDisplayName(locale), "{value}", NumberUtil.format1(Math.abs(value))));
            } else {
                CommandMessage message = value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_GLOBAL_LORE") : CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_GLOBAL_LORE_SUBTRACT");
                if (lore.size() > 0) {
                    lore.add(" ");
                }
                lore.add(TextUtil.replace(Lang.getMessage(message, locale), "{value}", NumberUtil.format1(Math.abs(value))));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    private String getNBTName(@Nullable Skill skill) {
        if (skill != null) {
            return StringUtils.capitalize((String)skill.toString().toLowerCase(Locale.ROOT));
        }
        return "Global";
    }
}

