/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.modifier;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.nbtapi.NBTCompound;
import com.archyx.aureliumskills.nbtapi.NBTItem;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Modifiers {
    private final AureliumSkills plugin;

    public Modifiers(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public ItemStack addModifier(ModifierType type, ItemStack item, Stat stat, double value) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getModifiersTypeCompound(nbtItem, type);
        compound.setDouble(this.getName(stat), value);
        return nbtItem.getItem();
    }

    public ItemStack convertFromLegacy(ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        for (ModifierType type : ModifierType.values()) {
            List<StatModifier> legacyModifiers = this.getLegacyModifiers(type, nbtItem);
            if (legacyModifiers.size() <= 0) continue;
            NBTCompound compound = ItemUtils.getModifiersTypeCompound(nbtItem, type);
            for (StatModifier modifier : legacyModifiers) {
                compound.setDouble(this.getName(modifier.getStat()), modifier.getValue());
            }
            for (String key : nbtItem.getKeys()) {
                if (!key.startsWith("skillsmodifier-" + type.name().toLowerCase(Locale.ENGLISH) + "-")) continue;
                nbtItem.removeKey(key);
            }
        }
        return nbtItem.getItem();
    }

    public ItemStack removeModifier(ModifierType type, ItemStack item, Stat stat) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getModifiersTypeCompound(nbtItem, type);
        compound.removeKey(this.getName(stat));
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public ItemStack removeAllModifiers(ModifierType type, ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        NBTCompound compound = ItemUtils.getModifiersTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            compound.removeKey(key);
        }
        ItemUtils.removeParentCompounds(compound);
        return nbtItem.getItem();
    }

    public List<StatModifier> getLegacyModifiers(ModifierType type, NBTItem nbtItem) {
        ArrayList<StatModifier> modifiers = new ArrayList<StatModifier>();
        for (String key : nbtItem.getKeys()) {
            int value;
            Stat stat;
            if (!key.contains("skillsmodifier-" + type.name().toLowerCase(Locale.ENGLISH) + "-")) continue;
            String[] keySplit = key.split("-");
            if (keySplit.length == 3) {
                stat = this.plugin.getStatRegistry().getStat(key.split("-")[2]);
                if (stat == null) continue;
                value = nbtItem.getInteger(key);
                modifiers.add(new StatModifier(key, stat, value));
                continue;
            }
            if (keySplit.length != 4 || (stat = this.plugin.getStatRegistry().getStat(key.split("-")[3])) == null) continue;
            value = nbtItem.getInteger(key);
            modifiers.add(new StatModifier(key, stat, value));
        }
        return modifiers;
    }

    public List<StatModifier> getModifiers(ModifierType type, ItemStack item) {
        NBTItem nbtItem = new NBTItem(item);
        ArrayList<StatModifier> modifiers = new ArrayList<StatModifier>();
        NBTCompound compound = ItemUtils.getModifiersTypeCompound(nbtItem, type);
        for (String key : compound.getKeys()) {
            Stat stat = this.plugin.getStatRegistry().getStat(key);
            if (stat == null) continue;
            double value = compound.getDouble(key);
            if (type == ModifierType.ITEM) {
                modifiers.add(new StatModifier("AureliumSkills.Modifiers.Item." + this.getName(stat), stat, value));
                continue;
            }
            if (type != ModifierType.ARMOR) continue;
            String slot = "Helmet";
            String mat = item.getType().toString();
            if (mat.contains("CHESTPLATE")) {
                slot = "Chestplate";
            } else if (mat.contains("LEGGINGS")) {
                slot = "Leggings";
            } else if (mat.contains("BOOTS")) {
                slot = "Boots";
            }
            modifiers.add(new StatModifier("AureliumSkills.Modifiers.Armor." + slot + "." + this.getName(stat), stat, value));
        }
        return modifiers;
    }

    public void addLore(ModifierType type, ItemStack item, Stat stat, double value, Locale locale) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore = meta.getLore() != null ? (meta.getLore().size() > 0 ? meta.getLore() : new LinkedList()) : new LinkedList();
            CommandMessage message = value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE") : CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE_SUBTRACT");
            lore.add(0, TextUtil.replace(Lang.getMessage(message, locale), "{stat}", stat.getDisplayName(locale), "{value}", NumberUtil.format1(Math.abs(value)), "{color}", stat.getColor(locale)));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    public void removeLore(ItemStack item, Stat stat, Locale locale) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore = meta.getLore();
            if (lore != null && lore.size() > 0) {
                lore.removeIf(line -> line.contains(stat.getDisplayName(locale)));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    private String getName(Stat stat) {
        return StringUtils.capitalize((String)stat.name().toLowerCase(Locale.ENGLISH));
    }
}

