/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.modifier;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Modifiers;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.modifier.Multipliers;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.requirement.Requirements;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class ModifierManager {
    private final AureliumSkills plugin;
    private final StatLeveler statLeveler;

    public ModifierManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.statLeveler = new StatLeveler(plugin);
    }

    public void reloadPlayer(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        Requirements requirements = new Requirements(this.plugin);
        Modifiers modifiers = new Modifiers(this.plugin);
        Multipliers multipliers = new Multipliers(this.plugin);
        if (playerData != null) {
            EntityEquipment entityEquipment;
            ItemStack itemOffHand;
            HashSet<Stat> statsToReload = new HashSet<Stat>();
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.getType() != Material.AIR) {
                for (StatModifier statModifier : modifiers.getModifiers(ModifierType.ITEM, item)) {
                    playerData.removeStatModifier(statModifier.getName());
                    statsToReload.add(statModifier.getStat());
                }
                for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
                    playerData.removeMultiplier(multiplier.getName());
                }
                if (requirements.meetsRequirements(ModifierType.ITEM, item, player)) {
                    for (StatModifier statModifier : modifiers.getModifiers(ModifierType.ITEM, item)) {
                        playerData.addStatModifier(statModifier, false);
                        statsToReload.add(statModifier.getStat());
                    }
                    for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
                        playerData.addMultiplier(multiplier);
                    }
                }
            }
            if ((itemOffHand = player.getInventory().getItemInOffHand()).getType() != Material.AIR) {
                for (StatModifier modifier : modifiers.getModifiers(ModifierType.ITEM, itemOffHand)) {
                    playerData.removeStatModifier(modifier.getName() + ".Offhand");
                    statsToReload.add(modifier.getStat());
                }
                for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, itemOffHand)) {
                    playerData.removeMultiplier(multiplier.getName() + ".Offhand");
                }
                if (requirements.meetsRequirements(ModifierType.ITEM, itemOffHand, player)) {
                    for (StatModifier modifier : modifiers.getModifiers(ModifierType.ITEM, itemOffHand)) {
                        StatModifier offHandModifier = new StatModifier(modifier.getName() + ".Offhand", modifier.getStat(), modifier.getValue());
                        playerData.addStatModifier(offHandModifier, false);
                        statsToReload.add(modifier.getStat());
                    }
                    for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, itemOffHand)) {
                        Multiplier offHandMultiplier = new Multiplier(multiplier.getName() + ".Offhand", multiplier.getSkill(), multiplier.getValue());
                        playerData.addMultiplier(offHandMultiplier);
                    }
                }
            }
            if ((entityEquipment = player.getEquipment()) != null) {
                for (ItemStack armor : entityEquipment.getArmorContents()) {
                    if (armor == null || armor.getType() == Material.AIR) continue;
                    for (StatModifier modifier : modifiers.getModifiers(ModifierType.ARMOR, armor)) {
                        playerData.removeStatModifier(modifier.getName());
                        statsToReload.add(modifier.getStat());
                    }
                    for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, armor)) {
                        playerData.removeMultiplier(multiplier.getName());
                    }
                    if (!requirements.meetsRequirements(ModifierType.ARMOR, armor, player)) continue;
                    for (StatModifier modifier : modifiers.getModifiers(ModifierType.ARMOR, armor)) {
                        playerData.addStatModifier(modifier, false);
                        statsToReload.add(modifier.getStat());
                    }
                    for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, armor)) {
                        playerData.addMultiplier(multiplier);
                    }
                }
            }
            for (Stat stat : statsToReload) {
                this.statLeveler.reloadStat(player, stat);
            }
        }
    }
}

