/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.modifier;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Modifiers;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.modifier.Multipliers;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.requirement.Requirements;
import com.archyx.aureliumskills.skills.foraging.ForagingAbilities;
import com.archyx.aureliumskills.skills.mining.MiningAbilities;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import com.archyx.aureliumskills.util.item.ItemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemListener
implements Listener {
    private final AureliumSkills plugin;
    private final Map<UUID, ItemStack> heldItems;
    private final Map<UUID, ItemStack> offHandItems;
    private final ForagingAbilities foragingAbilities;
    private final MiningAbilities miningAbilities;
    private final StatLeveler statLeveler;
    private final Modifiers modifiers;
    private final Requirements requirements;
    private final Multipliers multipliers;

    public ItemListener(AureliumSkills plugin) {
        this.plugin = plugin;
        this.heldItems = new HashMap<UUID, ItemStack>();
        this.offHandItems = new HashMap<UUID, ItemStack>();
        this.foragingAbilities = new ForagingAbilities(plugin);
        this.miningAbilities = new MiningAbilities(plugin);
        this.statLeveler = new StatLeveler(plugin);
        this.modifiers = new Modifiers(plugin);
        this.requirements = new Requirements(plugin);
        this.multipliers = new Multipliers(plugin);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerDataLoadEvent event) {
        Player player = event.getPlayerData().getPlayer();
        ItemStack held = player.getInventory().getItemInMainHand();
        this.heldItems.put(player.getUniqueId(), held);
        PlayerData playerData = event.getPlayerData();
        if (!held.getType().equals((Object)Material.AIR)) {
            if (OptionL.getBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(held = this.requirements.convertFromLegacy(this.modifiers.convertFromLegacy(held))).equals((Object)player.getInventory().getItemInMainHand())) {
                player.getInventory().setItemInMainHand(held);
            }
            for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ITEM, held)) {
                playerData.addStatModifier(modifier, false);
            }
            for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ITEM, held)) {
                playerData.addMultiplier(multiplier);
            }
        }
        if (OptionL.getBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
            ItemStack offHandItem = player.getInventory().getItemInOffHand();
            this.offHandItems.put(player.getUniqueId(), offHandItem);
            if (!offHandItem.getType().equals((Object)Material.AIR)) {
                if (OptionL.getBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(offHandItem = this.requirements.convertFromLegacy(this.modifiers.convertFromLegacy(offHandItem))).equals((Object)player.getInventory().getItemInOffHand())) {
                    player.getInventory().setItemInOffHand(offHandItem);
                }
                for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ITEM, offHandItem)) {
                    StatModifier offHandModifier = new StatModifier(modifier.getName() + ".Offhand", modifier.getStat(), modifier.getValue());
                    playerData.addStatModifier(offHandModifier);
                }
                for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ITEM, offHandItem)) {
                    Multiplier offHandMultiplier = new Multiplier(multiplier.getName() + ".Offhand", multiplier.getSkill(), multiplier.getValue());
                    playerData.addMultiplier(offHandMultiplier);
                }
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.heldItems.remove(player.getUniqueId());
        this.offHandItems.remove(player.getUniqueId());
    }

    public void scheduleTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ItemStack stored = (ItemStack)ItemListener.this.heldItems.get(player.getUniqueId());
                    ItemStack held = player.getInventory().getItemInMainHand();
                    if (stored != null) {
                        PlayerData playerData;
                        if (stored.equals((Object)held)) continue;
                        HashSet<Stat> statsToReload = new HashSet<Stat>();
                        if (!stored.getType().equals((Object)Material.AIR) && (playerData = ItemListener.this.plugin.getPlayerManager().getPlayerData(player)) != null) {
                            for (StatModifier modifier : ItemListener.this.modifiers.getModifiers(ModifierType.ITEM, stored)) {
                                playerData.removeStatModifier(modifier.getName(), false);
                                statsToReload.add(modifier.getStat());
                            }
                            for (Multiplier multiplier : ItemListener.this.multipliers.getMultipliers(ModifierType.ITEM, stored)) {
                                playerData.removeMultiplier(multiplier.getName());
                            }
                            if (ItemUtils.isAxe(stored.getType())) {
                                ItemListener.this.foragingAbilities.removeValor(playerData);
                            }
                            if (ItemUtils.isPickaxe(stored.getType())) {
                                ItemListener.this.miningAbilities.removeStamina(playerData);
                            }
                        }
                        if (!held.getType().equals((Object)Material.AIR)) {
                            if (OptionL.getBoolean(Option.MODIFIER_AUTO_CONVERT_FROM_LEGACY) && !(held = ItemListener.this.requirements.convertFromLegacy(ItemListener.this.modifiers.convertFromLegacy(held))).equals((Object)player.getInventory().getItemInMainHand())) {
                                player.getInventory().setItemInMainHand(held);
                            }
                            if ((playerData = ItemListener.this.plugin.getPlayerManager().getPlayerData(player)) != null) {
                                if (ItemListener.this.requirements.meetsRequirements(ModifierType.ITEM, held, player)) {
                                    for (StatModifier modifier : ItemListener.this.modifiers.getModifiers(ModifierType.ITEM, held)) {
                                        playerData.addStatModifier(modifier, false);
                                        statsToReload.add(modifier.getStat());
                                    }
                                    for (Multiplier multiplier : ItemListener.this.multipliers.getMultipliers(ModifierType.ITEM, held)) {
                                        playerData.addMultiplier(multiplier);
                                    }
                                }
                                if (ItemUtils.isAxe(held.getType())) {
                                    ItemListener.this.foragingAbilities.applyValor(playerData);
                                }
                                if (ItemUtils.isPickaxe(held.getType())) {
                                    ItemListener.this.miningAbilities.applyStamina(playerData);
                                }
                            }
                        }
                        for (Stat stat : statsToReload) {
                            ItemListener.this.statLeveler.reloadStat(player, stat);
                        }
                        ItemListener.this.heldItems.put(player.getUniqueId(), held.clone());
                        continue;
                    }
                    ItemListener.this.heldItems.put(player.getUniqueId(), held.clone());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)OptionL.getInt(Option.MODIFIER_ITEM_CHECK_PERIOD));
        this.scheduleOffHandTask();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSwap(PlayerSwapHandItemsEvent event) {
        if (!event.isCancelled() && OptionL.getBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
            Player player = event.getPlayer();
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData != null) {
                boolean meetsRequirements;
                ItemStack itemOffHand = event.getOffHandItem();
                ItemStack itemMainHand = event.getMainHandItem();
                this.offHandItems.put(player.getUniqueId(), itemOffHand);
                this.heldItems.put(player.getUniqueId(), itemMainHand);
                HashSet<String> offHandModifiers = new HashSet<String>();
                HashSet<Stat> statsToReload = new HashSet<Stat>();
                HashSet<String> offHandMultipliers = new HashSet<String>();
                if (itemOffHand != null && itemOffHand.getType() != Material.AIR) {
                    meetsRequirements = this.requirements.meetsRequirements(ModifierType.ITEM, itemOffHand, player);
                    for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ITEM, itemOffHand)) {
                        StatModifier offHandModifier = new StatModifier(modifier.getName() + ".Offhand", modifier.getStat(), modifier.getValue());
                        playerData.removeStatModifier(modifier.getName(), false);
                        if (meetsRequirements) {
                            playerData.addStatModifier(offHandModifier, false);
                        }
                        offHandModifiers.add(offHandModifier.getName());
                        statsToReload.add(modifier.getStat());
                    }
                    for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ITEM, itemOffHand)) {
                        Multiplier offHandMultiplier = new Multiplier(multiplier.getName() + ".Offhand", multiplier.getSkill(), multiplier.getValue());
                        playerData.removeMultiplier(multiplier.getName());
                        if (meetsRequirements) {
                            playerData.addMultiplier(offHandMultiplier);
                        }
                        offHandMultipliers.add(offHandMultiplier.getName());
                    }
                }
                if (itemMainHand != null && itemMainHand.getType() != Material.AIR) {
                    meetsRequirements = this.requirements.meetsRequirements(ModifierType.ITEM, itemMainHand, player);
                    for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ITEM, itemMainHand)) {
                        if (!offHandModifiers.contains(modifier.getName() + ".Offhand")) {
                            playerData.removeStatModifier(modifier.getName() + ".Offhand", false);
                        }
                        if (meetsRequirements) {
                            playerData.addStatModifier(modifier, false);
                        }
                        statsToReload.add(modifier.getStat());
                    }
                    for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ITEM, itemMainHand)) {
                        if (!offHandMultipliers.contains(multiplier.getName() + ".Offhand")) {
                            playerData.removeMultiplier(multiplier.getName() + ".Offhand");
                        }
                        if (!meetsRequirements) continue;
                        playerData.addMultiplier(multiplier);
                    }
                }
                for (Stat stat : statsToReload) {
                    this.statLeveler.reloadStat(player, stat);
                }
            }
        }
    }

    public void scheduleOffHandTask() {
        new BukkitRunnable(){

            public void run() {
                if (OptionL.getBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        ItemStack stored = (ItemStack)ItemListener.this.offHandItems.get(player.getUniqueId());
                        ItemStack held = player.getInventory().getItemInOffHand();
                        if (stored != null) {
                            PlayerData playerData;
                            if (stored.equals((Object)held)) continue;
                            if (!stored.getType().equals((Object)Material.AIR) && (playerData = ItemListener.this.plugin.getPlayerManager().getPlayerData(player)) != null) {
                                for (StatModifier modifier : ItemListener.this.modifiers.getModifiers(ModifierType.ITEM, stored)) {
                                    playerData.removeStatModifier(modifier.getName() + ".Offhand");
                                }
                                for (Multiplier multiplier : ItemListener.this.multipliers.getMultipliers(ModifierType.ITEM, stored)) {
                                    playerData.removeMultiplier(multiplier.getName() + ".Offhand");
                                }
                            }
                            if (!held.getType().equals((Object)Material.AIR) && (playerData = ItemListener.this.plugin.getPlayerManager().getPlayerData(player)) != null && ItemListener.this.requirements.meetsRequirements(ModifierType.ITEM, held, player)) {
                                for (StatModifier modifier : ItemListener.this.modifiers.getModifiers(ModifierType.ITEM, held)) {
                                    StatModifier offHandModifier = new StatModifier(modifier.getName() + ".Offhand", modifier.getStat(), modifier.getValue());
                                    playerData.addStatModifier(offHandModifier);
                                }
                                for (Multiplier multiplier : ItemListener.this.multipliers.getMultipliers(ModifierType.ITEM, held)) {
                                    Multiplier offHandMultiplier = new Multiplier(multiplier.getName() + ".Offhand", multiplier.getSkill(), multiplier.getValue());
                                    playerData.addMultiplier(offHandMultiplier);
                                }
                            }
                            ItemListener.this.offHandItems.put(player.getUniqueId(), held.clone());
                            continue;
                        }
                        ItemListener.this.offHandItems.put(player.getUniqueId(), held.clone());
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)OptionL.getInt(Option.MODIFIER_ITEM_CHECK_PERIOD));
    }
}

