/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.modifier;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Modifiers;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.modifier.Multipliers;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.requirement.Requirements;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import com.archyx.aureliumskills.util.armor.ArmorEquipEvent;
import com.archyx.aureliumskills.util.armor.ArmorType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorModifierListener
implements Listener {
    private final AureliumSkills plugin;
    private final Modifiers modifiers;
    private final Requirements requirements;
    private final Multipliers multipliers;
    private final StatLeveler statLeveler;
    private final Map<UUID, Map<ArmorType, ItemStack>> storedArmor;

    public ArmorModifierListener(AureliumSkills plugin) {
        this.plugin = plugin;
        this.modifiers = new Modifiers(plugin);
        this.requirements = new Requirements(plugin);
        this.multipliers = new Multipliers(plugin);
        this.statLeveler = new StatLeveler(plugin);
        this.storedArmor = new HashMap<UUID, Map<ArmorType, ItemStack>>();
        if (OptionL.getBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            this.startTimer();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerDataLoadEvent event) {
        Player player = event.getPlayerData().getPlayer();
        PlayerData playerData = event.getPlayerData();
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null) continue;
            if (OptionL.getBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
                this.storedArmor.computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(ArmorType.matchType(armor), armor.clone());
            }
            if (armor.getType().equals((Object)Material.AIR) || !this.requirements.meetsRequirements(ModifierType.ARMOR, armor, player)) continue;
            for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ARMOR, armor)) {
                playerData.addStatModifier(modifier, false);
            }
            for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ARMOR, armor)) {
                playerData.addMultiplier(multiplier);
            }
        }
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent event) {
        if (OptionL.getBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            return;
        }
        Player player = event.getPlayer();
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            ItemStack item;
            if (event.getNewArmorPiece() != null && event.getNewArmorPiece().getType() != Material.AIR && this.requirements.meetsRequirements(ModifierType.ARMOR, item = event.getNewArmorPiece(), player)) {
                for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ARMOR, item)) {
                    playerData.addStatModifier(modifier);
                }
                for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ARMOR, item)) {
                    playerData.addMultiplier(multiplier);
                }
            }
            if (event.getOldArmorPiece() != null && event.getOldArmorPiece().getType() != Material.AIR) {
                item = event.getOldArmorPiece();
                for (StatModifier modifier : this.modifiers.getModifiers(ModifierType.ARMOR, item)) {
                    playerData.removeStatModifier(modifier.getName());
                }
                for (Multiplier multiplier : this.multipliers.getMultipliers(ModifierType.ARMOR, item)) {
                    playerData.removeMultiplier(multiplier.getName());
                }
            }
        }
    }

    private void startTimer() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID uuid = player.getUniqueId();
                    Map playerStoredArmor = ArmorModifierListener.this.storedArmor.computeIfAbsent(uuid, k -> new HashMap());
                    for (ArmorType armorType : ArmorType.values()) {
                        PlayerData playerData;
                        ItemStack stored = (ItemStack)playerStoredArmor.get((Object)armorType);
                        ItemStack wearing = player.getInventory().getItem(armorType.getEquipmentSlot());
                        boolean remove = true;
                        if (stored == null) {
                            remove = false;
                        } else if (stored.equals((Object)wearing)) continue;
                        HashSet<Stat> statsToReload = new HashSet<Stat>();
                        if (remove && stored.getType() != Material.AIR) {
                            playerData = ArmorModifierListener.this.plugin.getPlayerManager().getPlayerData(player);
                            if (playerData == null) continue;
                            for (StatModifier modifier : ArmorModifierListener.this.modifiers.getModifiers(ModifierType.ARMOR, stored)) {
                                playerData.removeStatModifier(modifier.getName(), false);
                                statsToReload.add(modifier.getStat());
                            }
                            for (Multiplier multiplier : ArmorModifierListener.this.multipliers.getMultipliers(ModifierType.ARMOR, stored)) {
                                playerData.removeMultiplier(multiplier.getName());
                            }
                        }
                        if (wearing != null && wearing.getType() != Material.AIR) {
                            playerData = ArmorModifierListener.this.plugin.getPlayerManager().getPlayerData(player);
                            if (playerData == null) continue;
                            if (ArmorModifierListener.this.requirements.meetsRequirements(ModifierType.ARMOR, wearing, player)) {
                                for (StatModifier modifier : ArmorModifierListener.this.modifiers.getModifiers(ModifierType.ARMOR, wearing)) {
                                    playerData.addStatModifier(modifier, false);
                                    statsToReload.add(modifier.getStat());
                                }
                                for (Multiplier multiplier : ArmorModifierListener.this.multipliers.getMultipliers(ModifierType.ARMOR, wearing)) {
                                    playerData.addMultiplier(multiplier);
                                }
                            }
                        }
                        for (Stat stat : statsToReload) {
                            ArmorModifierListener.this.statLeveler.reloadStat(player, stat);
                        }
                        if (wearing != null) {
                            playerStoredArmor.put(armorType, wearing.clone());
                            continue;
                        }
                        playerStoredArmor.put(armorType, new ItemStack(Material.AIR));
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)OptionL.getInt(Option.MODIFIER_ARMOR_TIMER_CHECK_PERIOD));
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.storedArmor.remove(event.getPlayer().getUniqueId());
    }
}

