/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.templates;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.templates.ConfigurableTemplate;
import com.archyx.aureliumskills.menu.templates.ProgressLevelItem;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.RomanNumber;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnlockedTemplate
extends ConfigurableTemplate {
    private final ProgressLevelItem levelItem;

    public UnlockedTemplate(AureliumSkills plugin) {
        super(plugin, TemplateType.UNLOCKED, new String[]{"level_number", "rewards", "ability", "mana_ability", "unlocked"});
        this.levelItem = new ProgressLevelItem(plugin);
    }

    public ItemStack getItem(Skill skill, int level, Player player, Locale locale) {
        ItemStack item = this.baseItem.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.applyPlaceholders(TextUtil.replace(this.displayName, "{level_unlocked}", TextUtil.replace(Lang.getMessage(MenuMessage.LEVEL_UNLOCKED, locale), "{level}", RomanNumber.toRoman(level))), player));
            ArrayList<String> builtLore = new ArrayList<String>();
            for (int i = 0; i < this.lore.size(); ++i) {
                String line = (String)this.lore.get(i);
                Set placeholders = (Set)this.lorePlaceholders.get(i);
                Iterator iterator = placeholders.iterator();
                while (iterator.hasNext()) {
                    String placeholder;
                    switch (placeholder = (String)iterator.next()) {
                        case "level_number": {
                            line = TextUtil.replace(line, "{level_number}", TextUtil.replace(Lang.getMessage(MenuMessage.LEVEL_NUMBER, locale), "{level}", String.valueOf(level)));
                            break;
                        }
                        case "rewards": {
                            line = TextUtil.replace(line, "{rewards}", this.levelItem.getRewardsLore(skill, level, player, locale));
                            break;
                        }
                        case "ability": {
                            line = TextUtil.replace(line, "{ability}", this.levelItem.getAbilityLore(skill, level, locale));
                            break;
                        }
                        case "mana_ability": {
                            line = TextUtil.replace(line, "{mana_ability}", this.levelItem.getManaAbilityLore(skill, level, locale));
                            break;
                        }
                        case "unlocked": {
                            line = TextUtil.replace(line, "{unlocked}", Lang.getMessage(MenuMessage.UNLOCKED, locale));
                        }
                    }
                }
                builtLore.add(line);
            }
            meta.setLore(ItemUtils.formatLore(this.applyPlaceholders(builtLore, player)));
            item.setItemMeta(meta);
        }
        return item;
    }
}

