/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.templates;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.content.SlotPos;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.MenuLoader;
import com.archyx.aureliumskills.menu.templates.ConfigurableTemplate;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StatTemplate
extends ConfigurableTemplate {
    private final Map<Stat, SlotPos> positions = new HashMap<Stat, SlotPos>();
    private final Map<Stat, ItemStack> baseItems = new HashMap<Stat, ItemStack>();

    public StatTemplate(AureliumSkills plugin) {
        super(plugin, TemplateType.STAT, new String[]{"stat_desc", "skills", "your_level", "descriptors"});
    }

    @Override
    public void load(ConfigurationSection config) {
        try {
            Stat stat;
            String[] splitInput;
            for (String posInput : config.getStringList("pos")) {
                splitInput = posInput.split(" ");
                stat = this.plugin.getStatRegistry().getStat(splitInput[0]);
                if (stat == null) continue;
                int row = Integer.parseInt(splitInput[1]);
                int column = Integer.parseInt(splitInput[2]);
                this.positions.put(stat, SlotPos.of(row, column));
            }
            for (String materialInput : config.getStringList("material")) {
                splitInput = materialInput.split(" ", 2);
                stat = this.plugin.getStatRegistry().getStat(splitInput[0]);
                if (stat == null) continue;
                this.baseItems.put(stat, MenuLoader.parseItem(splitInput[1]));
            }
            this.displayName = TextUtil.replace(Objects.requireNonNull(config.getString("display_name")), "&", "\u00a7");
            ArrayList<String> lore = new ArrayList<String>();
            HashMap lorePlaceholders = new HashMap();
            int lineNum = 0;
            for (String line : config.getStringList("lore")) {
                HashSet<String> linePlaceholders = new HashSet<String>();
                lore.add(TextUtil.replace(line, "&", "\u00a7"));
                for (String placeholder : this.definedPlaceholders) {
                    if (!line.contains("{" + placeholder + "}")) continue;
                    linePlaceholders.add(placeholder);
                }
                lorePlaceholders.put(lineNum, linePlaceholders);
                ++lineNum;
            }
            this.lore = lore;
            this.lorePlaceholders = lorePlaceholders;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("[AureliumSkills] Error parsing template " + this.templateType.toString() + ", check error above for details!");
        }
    }

    public ItemStack getItem(Stat stat, PlayerData playerData, Player player, Locale locale) {
        ItemMeta meta;
        ItemStack item = this.baseItems.get(stat);
        if (item == null) {
            item = new ItemStack(Material.STONE);
        }
        if ((meta = (item = item.clone()).getItemMeta()) != null) {
            meta.setDisplayName(this.applyPlaceholders(TextUtil.replace(this.displayName, "{color}", stat.getColor(locale), "{stat}", stat.getDisplayName(locale)), player));
            ArrayList<String> builtLore = new ArrayList<String>();
            for (int i = 0; i < this.lore.size(); ++i) {
                String line = (String)this.lore.get(i);
                Set placeholders = (Set)this.lorePlaceholders.get(i);
                Iterator iterator = placeholders.iterator();
                while (iterator.hasNext()) {
                    String placeholder;
                    block6 : switch (placeholder = (String)iterator.next()) {
                        case "stat_desc": {
                            line = TextUtil.replace(line, "{stat_desc}", stat.getDescription(locale));
                            break;
                        }
                        case "skills": {
                            List<Skill> skillsLeveledBy = this.plugin.getRewardManager().getSkillsLeveledBy(stat);
                            StringBuilder skillList = new StringBuilder();
                            for (Skill skill : skillsLeveledBy) {
                                skillList.append(skill.getDisplayName(locale)).append(", ");
                            }
                            if (skillList.length() > 1) {
                                skillList.delete(skillList.length() - 2, skillList.length());
                            }
                            if (skillsLeveledBy.size() > 0) {
                                line = TextUtil.replace(line, "{skills}", TextUtil.replace(Lang.getMessage(MenuMessage.SKILLS, locale), "{skills}", skillList.toString()));
                                break;
                            }
                            line = TextUtil.replace(line, "{skills}", "");
                            break;
                        }
                        case "your_level": {
                            line = TextUtil.replace(line, "{your_level}", TextUtil.replace(Lang.getMessage(MenuMessage.YOUR_LEVEL, locale), "{color}", stat.getColor(locale), "{level}", NumberUtil.format1(playerData.getStatLevel(stat))));
                            break;
                        }
                        case "descriptors": {
                            switch (stat.name()) {
                                case "STRENGTH": {
                                    double strengthLevel = playerData.getStatLevel(Stats.STRENGTH);
                                    double attackDamage = strengthLevel * OptionL.getDouble(Option.STRENGTH_MODIFIER);
                                    if (OptionL.getBoolean(Option.STRENGTH_DISPLAY_DAMAGE_WITH_HEALTH_SCALING) && !OptionL.getBoolean(Option.STRENGTH_USE_PERCENT)) {
                                        attackDamage *= OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
                                    }
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.ATTACK_DAMAGE, locale), "{value}", NumberUtil.format2(attackDamage)));
                                    break block6;
                                }
                                case "HEALTH": {
                                    double modifier = playerData.getStatLevel(Stats.HEALTH) * OptionL.getDouble(Option.HEALTH_MODIFIER);
                                    double scaledHealth = modifier * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.HP, locale), "{value}", NumberUtil.format2(scaledHealth)));
                                    break block6;
                                }
                                case "REGENERATION": {
                                    double regenLevel = playerData.getStatLevel(Stats.REGENERATION);
                                    double saturatedRegen = regenLevel * OptionL.getDouble(Option.REGENERATION_SATURATED_MODIFIER) * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
                                    double hungerFullRegen = regenLevel * OptionL.getDouble(Option.REGENERATION_HUNGER_FULL_MODIFIER) * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
                                    double almostFullRegen = regenLevel * OptionL.getDouble(Option.REGENERATION_HUNGER_ALMOST_FULL_MODIFIER) * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
                                    double manaRegen = playerData.getManaRegen();
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.SATURATED_REGEN, locale), "{value}", NumberUtil.format2(saturatedRegen)) + "\n" + TextUtil.replace(Lang.getMessage(MenuMessage.FULL_HUNGER_REGEN, locale), "{value}", NumberUtil.format2(hungerFullRegen)) + "\n" + TextUtil.replace(Lang.getMessage(MenuMessage.ALMOST_FULL_HUNGER_REGEN, locale), "{value}", NumberUtil.format2(almostFullRegen)) + "\n" + TextUtil.replace(Lang.getMessage(MenuMessage.MANA_REGEN, locale), "{value}", String.valueOf((int)manaRegen)));
                                    break block6;
                                }
                                case "LUCK": {
                                    double luckLevel = playerData.getStatLevel(Stats.LUCK);
                                    double luck = luckLevel * OptionL.getDouble(Option.LUCK_MODIFIER);
                                    double doubleDropChance = luckLevel * OptionL.getDouble(Option.LUCK_DOUBLE_DROP_MODIFIER) * 100.0;
                                    if (doubleDropChance > OptionL.getDouble(Option.LUCK_DOUBLE_DROP_PERCENT_MAX)) {
                                        doubleDropChance = OptionL.getDouble(Option.LUCK_DOUBLE_DROP_PERCENT_MAX);
                                    }
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.LUCK, locale), "{value}", NumberUtil.format2(luck)) + "\n" + TextUtil.replace(Lang.getMessage(MenuMessage.DOUBLE_DROP_CHANCE, locale), "{value}", NumberUtil.format2(doubleDropChance)));
                                    break block6;
                                }
                                case "WISDOM": {
                                    double wisdomLevel = playerData.getStatLevel(Stats.WISDOM);
                                    double xpModifier = wisdomLevel * OptionL.getDouble(Option.WISDOM_EXPERIENCE_MODIFIER) * 100.0;
                                    double anvilCostReduction = (-1.0 * Math.pow(1.025, -1.0 * wisdomLevel * OptionL.getDouble(Option.WISDOM_ANVIL_COST_MODIFIER)) + 1.0) * 100.0;
                                    double maxMana = playerData.getMaxMana();
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.XP_GAIN, locale), "{value}", NumberUtil.format2(xpModifier)) + "\n" + TextUtil.replace(Lang.getMessage(MenuMessage.ANVIL_COST_REDUCTION, locale), "{value}", NumberUtil.format1(anvilCostReduction)) + " \n" + TextUtil.replace(Lang.getMessage(MenuMessage.MAX_MANA, locale), "{value}", NumberUtil.format1(maxMana)));
                                    break block6;
                                }
                                case "TOUGHNESS": {
                                    double toughness = playerData.getStatLevel(Stats.TOUGHNESS) * OptionL.getDouble(Option.TOUGHNESS_NEW_MODIFIER);
                                    double damageReduction = (-1.0 * Math.pow(1.01, -1.0 * toughness) + 1.0) * 100.0;
                                    line = TextUtil.replace(line, "{descriptors}", TextUtil.replace(Lang.getMessage(MenuMessage.INCOMING_DAMAGE, locale), "{value}", NumberUtil.format2(damageReduction)));
                                }
                            }
                        }
                    }
                }
                builtLore.add(line);
            }
            meta.setLore(ItemUtils.formatLore(this.applyPlaceholders(builtLore, player)));
            item.setItemMeta(meta);
        }
        return item;
    }

    public SlotPos getPos(Stat stat) {
        return this.positions.get(stat);
    }
}

