/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.templates;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.templates.ConfigurableTemplate;
import com.archyx.aureliumskills.menu.templates.ProgressLevelItem;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.math.RomanNumber;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InProgressTemplate
extends ConfigurableTemplate {
    private final ProgressLevelItem levelItem;

    public InProgressTemplate(AureliumSkills plugin) {
        super(plugin, TemplateType.IN_PROGRESS, new String[]{"level_number", "rewards", "ability", "mana_ability", "progress", "in_progress"});
        this.levelItem = new ProgressLevelItem(plugin);
    }

    public ItemStack getItem(Skill skill, PlayerData playerData, int level, Player player, Locale locale) {
        ItemStack item = this.baseItem.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.applyPlaceholders(TextUtil.replace(this.displayName, "{level_in_progress}", TextUtil.replace(Lang.getMessage(MenuMessage.LEVEL_IN_PROGRESS, locale), "{level}", RomanNumber.toRoman(level))), player));
            ArrayList<String> builtLore = new ArrayList<String>();
            for (int i = 0; i < this.lore.size(); ++i) {
                String line = (String)this.lore.get(i);
                Set placeholders = (Set)this.lorePlaceholders.get(i);
                Iterator iterator = placeholders.iterator();
                while (iterator.hasNext()) {
                    String placeholder;
                    switch (placeholder = (String)iterator.next()) {
                        case "level_number": {
                            line = TextUtil.replace(line, "{level_number}", TextUtil.replace(Lang.getMessage(MenuMessage.LEVEL_NUMBER, locale), "{level}", String.valueOf(level)));
                            break;
                        }
                        case "rewards": {
                            line = TextUtil.replace(line, "{rewards}", this.levelItem.getRewardsLore(skill, level, player, locale));
                            break;
                        }
                        case "ability": {
                            line = TextUtil.replace(line, "{ability}", this.levelItem.getAbilityLore(skill, level, locale));
                            break;
                        }
                        case "mana_ability": {
                            line = TextUtil.replace(line, "{mana_ability}", this.levelItem.getManaAbilityLore(skill, level, locale));
                            break;
                        }
                        case "progress": {
                            double currentXp = playerData.getSkillXp(skill);
                            double xpToNext = this.plugin.getLeveler().getXpRequirements().getXpRequired(skill, level);
                            line = TextUtil.replace(line, "{progress}", TextUtil.replace(Lang.getMessage(MenuMessage.PROGRESS, locale), "{percent}", NumberUtil.format2(currentXp / xpToNext * 100.0), "{current_xp}", NumberUtil.format2(currentXp), "{level_xp}", String.valueOf((int)xpToNext)));
                            break;
                        }
                        case "in_progress": {
                            line = TextUtil.replace(line, "{in_progress}", Lang.getMessage(MenuMessage.IN_PROGRESS, locale));
                        }
                    }
                }
                builtLore.add(line);
            }
            meta.setLore(ItemUtils.formatLore(this.applyPlaceholders(builtLore, player)));
            item.setItemMeta(meta);
        }
        return item;
    }
}

