/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.items;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.items.ConfigurableItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class YourSkillsItem
extends ConfigurableItem {
    public YourSkillsItem(AureliumSkills plugin) {
        super(plugin, ItemType.YOUR_SKILLS, new String[]{"desc", "hover", "click"});
    }

    public ItemStack getItem(Player player, Locale locale) {
        ItemStack item = this.baseItem.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.applyPlaceholders(TextUtil.replace(this.displayName, "{your_skills}", TextUtil.replace(Lang.getMessage(MenuMessage.YOUR_SKILLS, locale), "{player}", player.getName())), player));
            ArrayList<String> builtLore = new ArrayList<String>();
            for (int i = 0; i < this.lore.size(); ++i) {
                String line = (String)this.lore.get(i);
                Set placeholders = (Set)this.lorePlaceholders.get(i);
                Iterator iterator = placeholders.iterator();
                while (iterator.hasNext()) {
                    String placeholder;
                    switch (placeholder = (String)iterator.next()) {
                        case "desc": {
                            line = TextUtil.replace(line, "{desc}", Lang.getMessage(MenuMessage.YOUR_SKILLS_DESC, locale));
                            break;
                        }
                        case "hover": {
                            line = TextUtil.replace(line, "{hover}", Lang.getMessage(MenuMessage.YOUR_SKILLS_HOVER, locale));
                            break;
                        }
                        case "click": {
                            line = TextUtil.replace(line, "{click}", Lang.getMessage(MenuMessage.YOUR_SKILLS_CLICK, locale));
                        }
                    }
                }
                builtLore.add(line);
            }
            meta.setLore(ItemUtils.formatLore(this.applyPlaceholders(builtLore, player)));
            item.setItemMeta(meta);
        }
        return item;
    }
}

