/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.items;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.content.SlotPos;
import com.archyx.aureliumskills.menu.MenuLoader;
import com.archyx.aureliumskills.menu.items.ConfigurableItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.menu.templates.SkillInfoItem;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SkillItem
extends ConfigurableItem {
    private final SkillInfoItem skillInfoItem;
    private final Map<Skill, ItemStack> baseItems = new HashMap<Skill, ItemStack>();

    public SkillItem(AureliumSkills plugin) {
        super(plugin, ItemType.SKILL, new String[]{"skill_desc", "stats_leveled", "ability_levels", "mana_ability", "level", "progress_to_level", "max_level"});
        this.skillInfoItem = new SkillInfoItem(plugin);
    }

    @Override
    public void load(ConfigurationSection config) {
        try {
            this.pos = SlotPos.of(config.getInt("row"), config.getInt("column"));
            for (String materialInput : config.getStringList("material")) {
                String[] splitInput = materialInput.split(" ", 2);
                Skills skill = Skills.valueOf(splitInput[0]);
                this.baseItems.put(skill, MenuLoader.parseItem(splitInput[1]));
            }
            this.displayName = TextUtil.replace(Objects.requireNonNull(config.getString("display_name")), "&", "\u00a7");
            ArrayList<String> lore = new ArrayList<String>();
            HashMap lorePlaceholders = new HashMap();
            int lineNum = 0;
            for (String line : config.getStringList("lore")) {
                HashSet<String> linePlaceholders = new HashSet<String>();
                lore.add(TextUtil.replace(line, "&", "\u00a7"));
                for (String placeholder : this.definedPlaceholders) {
                    if (!line.contains("{" + placeholder + "}")) continue;
                    linePlaceholders.add(placeholder);
                }
                lorePlaceholders.put(lineNum, linePlaceholders);
                ++lineNum;
            }
            this.lore = lore;
            this.lorePlaceholders = lorePlaceholders;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("[AureliumSkills] Error parsing item " + this.itemType.toString() + ", check error above for details!");
        }
    }

    public ItemStack getItem(Skill skill, PlayerData playerData, Player player, Locale locale) {
        ItemStack baseItem = this.baseItems.get(skill);
        if (baseItem == null) {
            baseItem = new ItemStack(Material.STONE);
        }
        baseItem = baseItem.clone();
        return this.skillInfoItem.getItem(baseItem, skill, playerData, locale, this.displayName, this.lore, this.lorePlaceholders, player);
    }
}

