/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.items;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.items.ConfigurableItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RankItem
extends ConfigurableItem {
    public RankItem(AureliumSkills plugin) {
        super(plugin, ItemType.RANK, new String[]{"out_of", "percent"});
    }

    public ItemStack getItem(Skill skill, Player player, Locale locale) {
        ItemStack item = this.baseItem.clone();
        ItemMeta meta = item.getItemMeta();
        int rank = this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId());
        int size = this.plugin.getLeaderboardManager().getLeaderboard(skill).size();
        if (meta != null) {
            meta.setDisplayName(this.applyPlaceholders(TextUtil.replace(this.displayName, "{your_ranking}", Lang.getMessage(MenuMessage.YOUR_RANKING, locale)), player));
            ArrayList<String> builtLore = new ArrayList<String>();
            for (int i = 0; i < this.lore.size(); ++i) {
                String line = (String)this.lore.get(i);
                Set placeholders = (Set)this.lorePlaceholders.get(i);
                for (String placeholder : placeholders) {
                    if (placeholder.equals("out_of")) {
                        line = TextUtil.replace(line, "{out_of}", TextUtil.replace(Lang.getMessage(MenuMessage.RANK_OUT_OF, locale), "{rank}", String.valueOf(rank), "{total}", String.valueOf(size)));
                        continue;
                    }
                    if (!placeholder.equals("percent")) continue;
                    double percent = (double)rank / (double)size * 100.0;
                    if (percent > 1.0) {
                        line = TextUtil.replace(line, "{percent}", TextUtil.replace(Lang.getMessage(MenuMessage.RANK_PERCENT, locale), "{percent}", String.valueOf((int)percent)));
                        continue;
                    }
                    line = TextUtil.replace(line, "{percent}", TextUtil.replace(Lang.getMessage(MenuMessage.RANK_PERCENT, locale), "{percent}", NumberUtil.format2(percent)));
                }
                builtLore.add(line);
            }
            meta.setLore(ItemUtils.formatLore(this.applyPlaceholders(builtLore, player)));
            item.setItemMeta(meta);
        }
        return item;
    }
}

